/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;
import pl.gsmservice.gateway.models.components.Attachments;
import pl.gsmservice.gateway.models.components.Recipients;
import pl.gsmservice.gateway.utils.LazySingletonValue;
import pl.gsmservice.gateway.utils.Utils;

public class MmsMessage {
    @JsonProperty(value="recipients")
    private Recipients recipients;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="subject")
    private JsonNullable<String> subject;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="message")
    private JsonNullable<String> message;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="attachments")
    private Optional<? extends Attachments> attachments;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="date")
    private JsonNullable<OffsetDateTime> date;

    @JsonCreator
    public MmsMessage(@JsonProperty(value="recipients") Recipients recipients, @JsonProperty(value="subject") JsonNullable<String> subject, @JsonProperty(value="message") JsonNullable<String> message, @JsonProperty(value="attachments") Optional<? extends Attachments> attachments, @JsonProperty(value="date") JsonNullable<OffsetDateTime> date) {
        Utils.checkNotNull(recipients, "recipients");
        Utils.checkNotNull(subject, "subject");
        Utils.checkNotNull(message, "message");
        Utils.checkNotNull(attachments, "attachments");
        Utils.checkNotNull(date, "date");
        this.recipients = recipients;
        this.subject = subject;
        this.message = message;
        this.attachments = attachments;
        this.date = date;
    }

    public MmsMessage(Recipients recipients) {
        this(recipients, (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), Optional.empty(), (JsonNullable<OffsetDateTime>)JsonNullable.undefined());
    }

    @JsonIgnore
    public Recipients recipients() {
        return this.recipients;
    }

    @JsonIgnore
    public JsonNullable<String> subject() {
        return this.subject;
    }

    @JsonIgnore
    public JsonNullable<String> message() {
        return this.message;
    }

    @JsonIgnore
    public Optional<Attachments> attachments() {
        return this.attachments;
    }

    @JsonIgnore
    public JsonNullable<OffsetDateTime> date() {
        return this.date;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MmsMessage withRecipients(Recipients recipients) {
        Utils.checkNotNull(recipients, "recipients");
        this.recipients = recipients;
        return this;
    }

    public MmsMessage withSubject(String subject) {
        Utils.checkNotNull(subject, "subject");
        this.subject = JsonNullable.of((Object)subject);
        return this;
    }

    public MmsMessage withSubject(JsonNullable<String> subject) {
        Utils.checkNotNull(subject, "subject");
        this.subject = subject;
        return this;
    }

    public MmsMessage withMessage(String message) {
        Utils.checkNotNull(message, "message");
        this.message = JsonNullable.of((Object)message);
        return this;
    }

    public MmsMessage withMessage(JsonNullable<String> message) {
        Utils.checkNotNull(message, "message");
        this.message = message;
        return this;
    }

    public MmsMessage withAttachments(Attachments attachments) {
        Utils.checkNotNull(attachments, "attachments");
        this.attachments = Optional.ofNullable(attachments);
        return this;
    }

    public MmsMessage withAttachments(Optional<? extends Attachments> attachments) {
        Utils.checkNotNull(attachments, "attachments");
        this.attachments = attachments;
        return this;
    }

    public MmsMessage withDate(OffsetDateTime date) {
        Utils.checkNotNull(date, "date");
        this.date = JsonNullable.of((Object)date);
        return this;
    }

    public MmsMessage withDate(JsonNullable<OffsetDateTime> date) {
        Utils.checkNotNull(date, "date");
        this.date = date;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MmsMessage other = (MmsMessage)o;
        return Utils.enhancedDeepEquals(this.recipients, other.recipients) && Utils.enhancedDeepEquals(this.subject, other.subject) && Utils.enhancedDeepEquals(this.message, other.message) && Utils.enhancedDeepEquals(this.attachments, other.attachments) && Utils.enhancedDeepEquals(this.date, other.date);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.recipients, this.subject, this.message, this.attachments, this.date);
    }

    public String toString() {
        return Utils.toString(MmsMessage.class, "recipients", this.recipients, "subject", this.subject, "message", this.message, "attachments", this.attachments, "date", this.date);
    }

    public static final class Builder {
        private Recipients recipients;
        private JsonNullable<String> subject = JsonNullable.undefined();
        private JsonNullable<String> message = JsonNullable.undefined();
        private Optional<? extends Attachments> attachments = Optional.empty();
        private JsonNullable<OffsetDateTime> date;
        private static final LazySingletonValue<JsonNullable<OffsetDateTime>> _SINGLETON_VALUE_Date = new LazySingletonValue<JsonNullable<OffsetDateTime>>("date", "null", new TypeReference<JsonNullable<OffsetDateTime>>(){});

        private Builder() {
        }

        public Builder recipients(Recipients recipients) {
            Utils.checkNotNull(recipients, "recipients");
            this.recipients = recipients;
            return this;
        }

        public Builder subject(String subject) {
            Utils.checkNotNull(subject, "subject");
            this.subject = JsonNullable.of((Object)subject);
            return this;
        }

        public Builder subject(JsonNullable<String> subject) {
            Utils.checkNotNull(subject, "subject");
            this.subject = subject;
            return this;
        }

        public Builder message(String message) {
            Utils.checkNotNull(message, "message");
            this.message = JsonNullable.of((Object)message);
            return this;
        }

        public Builder message(JsonNullable<String> message) {
            Utils.checkNotNull(message, "message");
            this.message = message;
            return this;
        }

        public Builder attachments(Attachments attachments) {
            Utils.checkNotNull(attachments, "attachments");
            this.attachments = Optional.ofNullable(attachments);
            return this;
        }

        public Builder attachments(Optional<? extends Attachments> attachments) {
            Utils.checkNotNull(attachments, "attachments");
            this.attachments = attachments;
            return this;
        }

        public Builder date(OffsetDateTime date) {
            Utils.checkNotNull(date, "date");
            this.date = JsonNullable.of((Object)date);
            return this;
        }

        public Builder date(JsonNullable<OffsetDateTime> date) {
            Utils.checkNotNull(date, "date");
            this.date = date;
            return this;
        }

        public MmsMessage build() {
            if (this.date == null) {
                this.date = _SINGLETON_VALUE_Date.value();
            }
            return new MmsMessage(this.recipients, this.subject, this.message, this.attachments, this.date);
        }
    }
}

