/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;
import pl.gsmservice.gateway.models.components.MessageType;
import pl.gsmservice.gateway.utils.Utils;

public class Price {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="error")
    private JsonNullable<String> error;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="cid")
    private JsonNullable<String> cid;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="type")
    private Optional<? extends MessageType> type;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="recipient")
    private Optional<String> recipient;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="sender")
    private JsonNullable<String> sender;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="parts")
    private JsonNullable<Long> parts;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="unicode")
    private Optional<Boolean> unicode;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="flash")
    private Optional<Boolean> flash;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="price")
    private Optional<Float> price;

    @JsonCreator
    public Price(@JsonProperty(value="error") JsonNullable<String> error, @JsonProperty(value="cid") JsonNullable<String> cid, @JsonProperty(value="type") Optional<? extends MessageType> type, @JsonProperty(value="recipient") Optional<String> recipient, @JsonProperty(value="sender") JsonNullable<String> sender, @JsonProperty(value="parts") JsonNullable<Long> parts, @JsonProperty(value="unicode") Optional<Boolean> unicode, @JsonProperty(value="flash") Optional<Boolean> flash, @JsonProperty(value="price") Optional<Float> price) {
        Utils.checkNotNull(error, "error");
        Utils.checkNotNull(cid, "cid");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(recipient, "recipient");
        Utils.checkNotNull(sender, "sender");
        Utils.checkNotNull(parts, "parts");
        Utils.checkNotNull(unicode, "unicode");
        Utils.checkNotNull(flash, "flash");
        Utils.checkNotNull(price, "price");
        this.error = error;
        this.cid = cid;
        this.type = type;
        this.recipient = recipient;
        this.sender = sender;
        this.parts = parts;
        this.unicode = unicode;
        this.flash = flash;
        this.price = price;
    }

    public Price() {
        this((JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), Optional.empty(), Optional.empty(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<Long>)JsonNullable.undefined(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public JsonNullable<String> error() {
        return this.error;
    }

    @JsonIgnore
    public JsonNullable<String> cid() {
        return this.cid;
    }

    @JsonIgnore
    public Optional<MessageType> type() {
        return this.type;
    }

    @JsonIgnore
    public Optional<String> recipient() {
        return this.recipient;
    }

    @JsonIgnore
    public JsonNullable<String> sender() {
        return this.sender;
    }

    @JsonIgnore
    public JsonNullable<Long> parts() {
        return this.parts;
    }

    @JsonIgnore
    public Optional<Boolean> unicode() {
        return this.unicode;
    }

    @JsonIgnore
    public Optional<Boolean> flash() {
        return this.flash;
    }

    @JsonIgnore
    public Optional<Float> price() {
        return this.price;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Price withError(String error) {
        Utils.checkNotNull(error, "error");
        this.error = JsonNullable.of((Object)error);
        return this;
    }

    public Price withError(JsonNullable<String> error) {
        Utils.checkNotNull(error, "error");
        this.error = error;
        return this;
    }

    public Price withCid(String cid) {
        Utils.checkNotNull(cid, "cid");
        this.cid = JsonNullable.of((Object)cid);
        return this;
    }

    public Price withCid(JsonNullable<String> cid) {
        Utils.checkNotNull(cid, "cid");
        this.cid = cid;
        return this;
    }

    public Price withType(MessageType type) {
        Utils.checkNotNull(type, "type");
        this.type = Optional.ofNullable(type);
        return this;
    }

    public Price withType(Optional<? extends MessageType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    public Price withRecipient(String recipient) {
        Utils.checkNotNull(recipient, "recipient");
        this.recipient = Optional.ofNullable(recipient);
        return this;
    }

    public Price withRecipient(Optional<String> recipient) {
        Utils.checkNotNull(recipient, "recipient");
        this.recipient = recipient;
        return this;
    }

    public Price withSender(String sender) {
        Utils.checkNotNull(sender, "sender");
        this.sender = JsonNullable.of((Object)sender);
        return this;
    }

    public Price withSender(JsonNullable<String> sender) {
        Utils.checkNotNull(sender, "sender");
        this.sender = sender;
        return this;
    }

    public Price withParts(long parts) {
        Utils.checkNotNull(parts, "parts");
        this.parts = JsonNullable.of((Object)parts);
        return this;
    }

    public Price withParts(JsonNullable<Long> parts) {
        Utils.checkNotNull(parts, "parts");
        this.parts = parts;
        return this;
    }

    public Price withUnicode(boolean unicode) {
        Utils.checkNotNull(unicode, "unicode");
        this.unicode = Optional.ofNullable(unicode);
        return this;
    }

    public Price withUnicode(Optional<Boolean> unicode) {
        Utils.checkNotNull(unicode, "unicode");
        this.unicode = unicode;
        return this;
    }

    public Price withFlash(boolean flash) {
        Utils.checkNotNull(flash, "flash");
        this.flash = Optional.ofNullable(flash);
        return this;
    }

    public Price withFlash(Optional<Boolean> flash) {
        Utils.checkNotNull(flash, "flash");
        this.flash = flash;
        return this;
    }

    public Price withPrice(float price) {
        Utils.checkNotNull(Float.valueOf(price), "price");
        this.price = Optional.ofNullable(Float.valueOf(price));
        return this;
    }

    public Price withPrice(Optional<Float> price) {
        Utils.checkNotNull(price, "price");
        this.price = price;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Price other = (Price)o;
        return Utils.enhancedDeepEquals(this.error, other.error) && Utils.enhancedDeepEquals(this.cid, other.cid) && Utils.enhancedDeepEquals(this.type, other.type) && Utils.enhancedDeepEquals(this.recipient, other.recipient) && Utils.enhancedDeepEquals(this.sender, other.sender) && Utils.enhancedDeepEquals(this.parts, other.parts) && Utils.enhancedDeepEquals(this.unicode, other.unicode) && Utils.enhancedDeepEquals(this.flash, other.flash) && Utils.enhancedDeepEquals(this.price, other.price);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.error, this.cid, this.type, this.recipient, this.sender, this.parts, this.unicode, this.flash, this.price);
    }

    public String toString() {
        return Utils.toString(Price.class, "error", this.error, "cid", this.cid, "type", this.type, "recipient", this.recipient, "sender", this.sender, "parts", this.parts, "unicode", this.unicode, "flash", this.flash, "price", this.price);
    }

    public static final class Builder {
        private JsonNullable<String> error = JsonNullable.undefined();
        private JsonNullable<String> cid = JsonNullable.undefined();
        private Optional<? extends MessageType> type = Optional.empty();
        private Optional<String> recipient = Optional.empty();
        private JsonNullable<String> sender = JsonNullable.undefined();
        private JsonNullable<Long> parts = JsonNullable.undefined();
        private Optional<Boolean> unicode = Optional.empty();
        private Optional<Boolean> flash = Optional.empty();
        private Optional<Float> price = Optional.empty();

        private Builder() {
        }

        public Builder error(String error) {
            Utils.checkNotNull(error, "error");
            this.error = JsonNullable.of((Object)error);
            return this;
        }

        public Builder error(JsonNullable<String> error) {
            Utils.checkNotNull(error, "error");
            this.error = error;
            return this;
        }

        public Builder cid(String cid) {
            Utils.checkNotNull(cid, "cid");
            this.cid = JsonNullable.of((Object)cid);
            return this;
        }

        public Builder cid(JsonNullable<String> cid) {
            Utils.checkNotNull(cid, "cid");
            this.cid = cid;
            return this;
        }

        public Builder type(MessageType type) {
            Utils.checkNotNull(type, "type");
            this.type = Optional.ofNullable(type);
            return this;
        }

        public Builder type(Optional<? extends MessageType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }

        public Builder recipient(String recipient) {
            Utils.checkNotNull(recipient, "recipient");
            this.recipient = Optional.ofNullable(recipient);
            return this;
        }

        public Builder recipient(Optional<String> recipient) {
            Utils.checkNotNull(recipient, "recipient");
            this.recipient = recipient;
            return this;
        }

        public Builder sender(String sender) {
            Utils.checkNotNull(sender, "sender");
            this.sender = JsonNullable.of((Object)sender);
            return this;
        }

        public Builder sender(JsonNullable<String> sender) {
            Utils.checkNotNull(sender, "sender");
            this.sender = sender;
            return this;
        }

        public Builder parts(long parts) {
            Utils.checkNotNull(parts, "parts");
            this.parts = JsonNullable.of((Object)parts);
            return this;
        }

        public Builder parts(JsonNullable<Long> parts) {
            Utils.checkNotNull(parts, "parts");
            this.parts = parts;
            return this;
        }

        public Builder unicode(boolean unicode) {
            Utils.checkNotNull(unicode, "unicode");
            this.unicode = Optional.ofNullable(unicode);
            return this;
        }

        public Builder unicode(Optional<Boolean> unicode) {
            Utils.checkNotNull(unicode, "unicode");
            this.unicode = unicode;
            return this;
        }

        public Builder flash(boolean flash) {
            Utils.checkNotNull(flash, "flash");
            this.flash = Optional.ofNullable(flash);
            return this;
        }

        public Builder flash(Optional<Boolean> flash) {
            Utils.checkNotNull(flash, "flash");
            this.flash = flash;
            return this;
        }

        public Builder price(float price) {
            Utils.checkNotNull(Float.valueOf(price), "price");
            this.price = Optional.ofNullable(Float.valueOf(price));
            return this;
        }

        public Builder price(Optional<Float> price) {
            Utils.checkNotNull(price, "price");
            this.price = price;
            return this;
        }

        public Price build() {
            return new Price(this.error, this.cid, this.type, this.recipient, this.sender, this.parts, this.unicode, this.flash, this.price);
        }
    }
}

