/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import pl.gsmservice.gateway.utils.Utils;

public class Sender {
    @JsonProperty(value="sender")
    private String sender;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="is_default")
    private boolean isDefault;

    @JsonCreator
    public Sender(@JsonProperty(value="sender") String sender, @JsonProperty(value="status") String status, @JsonProperty(value="is_default") boolean isDefault) {
        Utils.checkNotNull(sender, "sender");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(isDefault, "isDefault");
        this.sender = sender;
        this.status = status;
        this.isDefault = isDefault;
    }

    @JsonIgnore
    public String sender() {
        return this.sender;
    }

    @JsonIgnore
    public String status() {
        return this.status;
    }

    @JsonIgnore
    public boolean isDefault() {
        return this.isDefault;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Sender withSender(String sender) {
        Utils.checkNotNull(sender, "sender");
        this.sender = sender;
        return this;
    }

    public Sender withStatus(String status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public Sender withIsDefault(boolean isDefault) {
        Utils.checkNotNull(isDefault, "isDefault");
        this.isDefault = isDefault;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sender other = (Sender)o;
        return Utils.enhancedDeepEquals(this.sender, other.sender) && Utils.enhancedDeepEquals(this.status, other.status) && Utils.enhancedDeepEquals(this.isDefault, other.isDefault);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.sender, this.status, this.isDefault);
    }

    public String toString() {
        return Utils.toString(Sender.class, "sender", this.sender, "status", this.status, "isDefault", this.isDefault);
    }

    public static final class Builder {
        private String sender;
        private String status;
        private Boolean isDefault;

        private Builder() {
        }

        public Builder sender(String sender) {
            Utils.checkNotNull(sender, "sender");
            this.sender = sender;
            return this;
        }

        public Builder status(String status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder isDefault(boolean isDefault) {
            Utils.checkNotNull(isDefault, "isDefault");
            this.isDefault = isDefault;
            return this;
        }

        public Sender build() {
            return new Sender(this.sender, this.status, this.isDefault);
        }
    }
}

