/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import pl.gsmservice.gateway.utils.Utils;

public class SenderInput {
    @JsonProperty(value="sender")
    private String sender;
    @JsonProperty(value="description")
    private String description;

    @JsonCreator
    public SenderInput(@JsonProperty(value="sender") String sender, @JsonProperty(value="description") String description) {
        Utils.checkNotNull(sender, "sender");
        Utils.checkNotNull(description, "description");
        this.sender = sender;
        this.description = description;
    }

    @JsonIgnore
    public String sender() {
        return this.sender;
    }

    @JsonIgnore
    public String description() {
        return this.description;
    }

    public static Builder builder() {
        return new Builder();
    }

    public SenderInput withSender(String sender) {
        Utils.checkNotNull(sender, "sender");
        this.sender = sender;
        return this;
    }

    public SenderInput withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SenderInput other = (SenderInput)o;
        return Utils.enhancedDeepEquals(this.sender, other.sender) && Utils.enhancedDeepEquals(this.description, other.description);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.sender, this.description);
    }

    public String toString() {
        return Utils.toString(SenderInput.class, "sender", this.sender, "description", this.description);
    }

    public static final class Builder {
        private String sender;
        private String description;

        private Builder() {
        }

        public Builder sender(String sender) {
            Utils.checkNotNull(sender, "sender");
            this.sender = sender;
            return this;
        }

        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }

        public SenderInput build() {
            return new SenderInput(this.sender, this.description);
        }
    }
}

