/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class SmsType {
    public static final SmsType SmsPro = new SmsType(1L);
    public static final SmsType SmsEco = new SmsType(3L);
    public static final SmsType SmsTwoWay = new SmsType(4L);
    private static final Map<Long, SmsType> values = SmsType.createValuesMap();
    private static final Map<Long, SmsTypeEnum> enums = SmsType.createEnumsMap();
    private final long value;

    private SmsType(long value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SmsType of(long value) {
        Class<SmsType> clazz = SmsType.class;
        synchronized (SmsType.class) {
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new SmsType((long)v));
        }
    }

    public long value() {
        return this.value;
    }

    public Optional<SmsTypeEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SmsType other = (SmsType)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "SmsType [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SmsType[] values() {
        Class<SmsType> clazz = SmsType.class;
        synchronized (SmsType.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new SmsType[0]);
        }
    }

    private static final Map<Long, SmsType> createValuesMap() {
        LinkedHashMap<Long, SmsType> map = new LinkedHashMap<Long, SmsType>();
        map.put(1L, SmsPro);
        map.put(3L, SmsEco);
        map.put(4L, SmsTwoWay);
        return map;
    }

    private static final Map<Long, SmsTypeEnum> createEnumsMap() {
        HashMap<Long, SmsTypeEnum> map = new HashMap<Long, SmsTypeEnum>();
        map.put(1L, SmsTypeEnum.SmsPro);
        map.put(3L, SmsTypeEnum.SmsEco);
        map.put(4L, SmsTypeEnum.SmsTwoWay);
        return map;
    }

    public static enum SmsTypeEnum {
        SmsPro(1L),
        SmsEco(3L),
        SmsTwoWay(4L);

        private final long value;

        private SmsTypeEnum(long value) {
            this.value = value;
        }

        public long value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<SmsType> {
        protected _Deserializer() {
            super(SmsType.class);
        }

        public SmsType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            long v = (Long)p.readValueAs((TypeReference)new TypeReference<Long>(){});
            return SmsType.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<SmsType> {
        protected _Serializer() {
            super(SmsType.class);
        }

        public void serialize(SmsType value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

