/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.errors;

import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import pl.gsmservice.gateway.utils.Blob;
import pl.gsmservice.gateway.utils.Utils;

public class UncheckedSDKError
extends RuntimeException {
    private final HttpResponse<Blob> rawResponse;
    private final int code;
    private final String message;
    private final byte[] body;

    public UncheckedSDKError(HttpResponse<Blob> rawResponse, int code, String message, byte[] body) {
        super(message);
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(message, "message");
        Utils.checkNotNull(body, "body");
        this.rawResponse = rawResponse;
        this.code = code;
        this.message = message;
        this.body = body;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UncheckedSDKError other = (UncheckedSDKError)o;
        return Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.code, other.code) && Objects.deepEquals(this.message, other.message) && Objects.deepEquals(this.body, other.body);
    }

    public int hashCode() {
        return Objects.hash(this.rawResponse, this.code, this.message, this.body);
    }

    @Override
    public String toString() {
        return Utils.toString(UncheckedSDKError.class, "requestMethod", this.rawResponse.request().method(), "requestUri", this.rawResponse.request().uri(), "code", this.code, "responseHeaders", this.rawResponse.headers().map(), "message", this.message, "body", this.bodyAsString());
    }

    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    public int code() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

    public byte[] body() {
        return this.body;
    }

    public String bodyAsString() {
        return new String(this.body(), StandardCharsets.UTF_8);
    }
}

