/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.operations;

import java.util.List;
import java.util.Optional;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.models.operations.CancelMessagesRequest;
import pl.gsmservice.gateway.models.operations.CancelMessagesResponse;
import pl.gsmservice.gateway.operations.CancelMessages;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;
import pl.gsmservice.gateway.utils.RetryConfig;
import pl.gsmservice.gateway.utils.Utils;

public class CancelMessagesRequestBuilder {
    private List<Long> ids;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public CancelMessagesRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CancelMessagesRequestBuilder ids(List<Long> ids) {
        Utils.checkNotNull(ids, "ids");
        this.ids = ids;
        return this;
    }

    public CancelMessagesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public CancelMessagesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private CancelMessagesRequest buildRequest() {
        CancelMessagesRequest request = new CancelMessagesRequest(this.ids);
        return request;
    }

    public CancelMessagesResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        CancelMessages.Sync operation = new CancelMessages.Sync(this.sdkConfiguration, options, this._headers);
        CancelMessagesRequest request = this.buildRequest();
        return (CancelMessagesResponse)operation.handleResponse(operation.doRequest(request));
    }
}

