/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.operations;

import java.util.List;
import java.util.Optional;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.models.operations.GetMessagesRequest;
import pl.gsmservice.gateway.models.operations.GetMessagesResponse;
import pl.gsmservice.gateway.operations.GetMessages;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;
import pl.gsmservice.gateway.utils.RetryConfig;
import pl.gsmservice.gateway.utils.Utils;

public class GetMessagesRequestBuilder {
    private List<Long> ids;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public GetMessagesRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public GetMessagesRequestBuilder ids(List<Long> ids) {
        Utils.checkNotNull(ids, "ids");
        this.ids = ids;
        return this;
    }

    public GetMessagesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetMessagesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private GetMessagesRequest buildRequest() {
        GetMessagesRequest request = new GetMessagesRequest(this.ids);
        return request;
    }

    public GetMessagesResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        GetMessages.Sync operation = new GetMessages.Sync(this.sdkConfiguration, options, this._headers);
        GetMessagesRequest request = this.buildRequest();
        return (GetMessagesResponse)operation.handleResponse(operation.doRequest(request));
    }
}

