/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.operations;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.models.operations.ListIncomingMessagesRequest;
import pl.gsmservice.gateway.models.operations.ListIncomingMessagesResponse;
import pl.gsmservice.gateway.operations.ListIncomingMessages;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.LazySingletonValue;
import pl.gsmservice.gateway.utils.Options;
import pl.gsmservice.gateway.utils.RetryConfig;
import pl.gsmservice.gateway.utils.Utils;

public class ListIncomingMessagesRequestBuilder {
    private Optional<Long> page = Utils.readDefaultOrConstValue("page", "1", new TypeReference<Optional<Long>>(){});
    private Optional<Long> limit = Utils.readDefaultOrConstValue("limit", "10", new TypeReference<Optional<Long>>(){});
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();
    private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Page = new LazySingletonValue<Optional<Long>>("page", "1", new TypeReference<Optional<Long>>(){});
    private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Limit = new LazySingletonValue<Optional<Long>>("limit", "10", new TypeReference<Optional<Long>>(){});

    public ListIncomingMessagesRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public ListIncomingMessagesRequestBuilder page(long page) {
        Utils.checkNotNull(page, "page");
        this.page = Optional.of(page);
        return this;
    }

    public ListIncomingMessagesRequestBuilder page(Optional<Long> page) {
        Utils.checkNotNull(page, "page");
        this.page = page;
        return this;
    }

    public ListIncomingMessagesRequestBuilder limit(long limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.of(limit);
        return this;
    }

    public ListIncomingMessagesRequestBuilder limit(Optional<Long> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public ListIncomingMessagesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public ListIncomingMessagesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private ListIncomingMessagesRequest buildRequest() {
        if (this.page == null) {
            this.page = _SINGLETON_VALUE_Page.value();
        }
        if (this.limit == null) {
            this.limit = _SINGLETON_VALUE_Limit.value();
        }
        ListIncomingMessagesRequest request = new ListIncomingMessagesRequest(this.page, this.limit);
        return request;
    }

    public ListIncomingMessagesResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        ListIncomingMessages.Sync operation = new ListIncomingMessages.Sync(this.sdkConfiguration, options, this._headers);
        ListIncomingMessagesRequest request = this.buildRequest();
        return (ListIncomingMessagesResponse)operation.handleResponse(operation.doRequest(request));
    }
}

