/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import pl.gsmservice.gateway.models.components.IncomingMessage;
import pl.gsmservice.gateway.utils.Response;
import pl.gsmservice.gateway.utils.Utils;

public class ListIncomingMessagesResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends List<IncomingMessage>> incomingMessages;
    private Map<String, List<String>> headers;

    @JsonCreator
    public ListIncomingMessagesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends List<IncomingMessage>> incomingMessages, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(incomingMessages, "incomingMessages");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.incomingMessages = incomingMessages;
        this.headers = headers;
    }

    public ListIncomingMessagesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<List<IncomingMessage>> incomingMessages() {
        return this.incomingMessages;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ListIncomingMessagesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public ListIncomingMessagesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public ListIncomingMessagesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public ListIncomingMessagesResponse withIncomingMessages(List<IncomingMessage> incomingMessages) {
        Utils.checkNotNull(incomingMessages, "incomingMessages");
        this.incomingMessages = Optional.ofNullable(incomingMessages);
        return this;
    }

    public ListIncomingMessagesResponse withIncomingMessages(Optional<? extends List<IncomingMessage>> incomingMessages) {
        Utils.checkNotNull(incomingMessages, "incomingMessages");
        this.incomingMessages = incomingMessages;
        return this;
    }

    public ListIncomingMessagesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListIncomingMessagesResponse other = (ListIncomingMessagesResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.incomingMessages, other.incomingMessages) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.incomingMessages, this.headers);
    }

    public String toString() {
        return Utils.toString(ListIncomingMessagesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "incomingMessages", this.incomingMessages, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends List<IncomingMessage>> incomingMessages = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder incomingMessages(List<IncomingMessage> incomingMessages) {
            Utils.checkNotNull(incomingMessages, "incomingMessages");
            this.incomingMessages = Optional.ofNullable(incomingMessages);
            return this;
        }

        public Builder incomingMessages(Optional<? extends List<IncomingMessage>> incomingMessages) {
            Utils.checkNotNull(incomingMessages, "incomingMessages");
            this.incomingMessages = incomingMessages;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public ListIncomingMessagesResponse build() {
            return new ListIncomingMessagesResponse(this.contentType, this.statusCode, this.rawResponse, this.incomingMessages, this.headers);
        }
    }
}

