/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;
import pl.gsmservice.gateway.utils.LazySingletonValue;
import pl.gsmservice.gateway.utils.SpeakeasyMetadata;
import pl.gsmservice.gateway.utils.Utils;

public class ListMessagesRequest {
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=page")
    private Optional<Long> page;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=limit")
    private Optional<Long> limit;

    @JsonCreator
    public ListMessagesRequest(Optional<Long> page, Optional<Long> limit) {
        Utils.checkNotNull(page, "page");
        Utils.checkNotNull(limit, "limit");
        this.page = page;
        this.limit = limit;
    }

    public ListMessagesRequest() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<Long> page() {
        return this.page;
    }

    @JsonIgnore
    public Optional<Long> limit() {
        return this.limit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ListMessagesRequest withPage(long page) {
        Utils.checkNotNull(page, "page");
        this.page = Optional.ofNullable(page);
        return this;
    }

    public ListMessagesRequest withPage(Optional<Long> page) {
        Utils.checkNotNull(page, "page");
        this.page = page;
        return this;
    }

    public ListMessagesRequest withLimit(long limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.ofNullable(limit);
        return this;
    }

    public ListMessagesRequest withLimit(Optional<Long> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListMessagesRequest other = (ListMessagesRequest)o;
        return Utils.enhancedDeepEquals(this.page, other.page) && Utils.enhancedDeepEquals(this.limit, other.limit);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.page, this.limit);
    }

    public String toString() {
        return Utils.toString(ListMessagesRequest.class, "page", this.page, "limit", this.limit);
    }

    public static final class Builder {
        private Optional<Long> page;
        private Optional<Long> limit;
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Page = new LazySingletonValue<Optional<Long>>("page", "1", new TypeReference<Optional<Long>>(){});
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Limit = new LazySingletonValue<Optional<Long>>("limit", "10", new TypeReference<Optional<Long>>(){});

        private Builder() {
        }

        public Builder page(long page) {
            Utils.checkNotNull(page, "page");
            this.page = Optional.ofNullable(page);
            return this;
        }

        public Builder page(Optional<Long> page) {
            Utils.checkNotNull(page, "page");
            this.page = page;
            return this;
        }

        public Builder limit(long limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Optional<Long> limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = limit;
            return this;
        }

        public ListMessagesRequest build() {
            if (this.page == null) {
                this.page = _SINGLETON_VALUE_Page.value();
            }
            if (this.limit == null) {
                this.limit = _SINGLETON_VALUE_Limit.value();
            }
            return new ListMessagesRequest(this.page, this.limit);
        }
    }
}

