/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.operations;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.models.operations.ListMessagesRequest;
import pl.gsmservice.gateway.models.operations.ListMessagesResponse;
import pl.gsmservice.gateway.operations.ListMessages;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.LazySingletonValue;
import pl.gsmservice.gateway.utils.Options;
import pl.gsmservice.gateway.utils.RetryConfig;
import pl.gsmservice.gateway.utils.Utils;

public class ListMessagesRequestBuilder {
    private Optional<Long> page = Utils.readDefaultOrConstValue("page", "1", new TypeReference<Optional<Long>>(){});
    private Optional<Long> limit = Utils.readDefaultOrConstValue("limit", "10", new TypeReference<Optional<Long>>(){});
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();
    private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Page = new LazySingletonValue<Optional<Long>>("page", "1", new TypeReference<Optional<Long>>(){});
    private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Limit = new LazySingletonValue<Optional<Long>>("limit", "10", new TypeReference<Optional<Long>>(){});

    public ListMessagesRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public ListMessagesRequestBuilder page(long page) {
        Utils.checkNotNull(page, "page");
        this.page = Optional.of(page);
        return this;
    }

    public ListMessagesRequestBuilder page(Optional<Long> page) {
        Utils.checkNotNull(page, "page");
        this.page = page;
        return this;
    }

    public ListMessagesRequestBuilder limit(long limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.of(limit);
        return this;
    }

    public ListMessagesRequestBuilder limit(Optional<Long> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public ListMessagesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public ListMessagesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private ListMessagesRequest buildRequest() {
        if (this.page == null) {
            this.page = _SINGLETON_VALUE_Page.value();
        }
        if (this.limit == null) {
            this.limit = _SINGLETON_VALUE_Limit.value();
        }
        ListMessagesRequest request = new ListMessagesRequest(this.page, this.limit);
        return request;
    }

    public ListMessagesResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        ListMessages.Sync operation = new ListMessages.Sync(this.sdkConfiguration, options, this._headers);
        ListMessagesRequest request = this.buildRequest();
        return (ListMessagesResponse)operation.handleResponse(operation.doRequest(request));
    }
}

