/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Optional;
import pl.gsmservice.gateway.models.components.Sender;
import pl.gsmservice.gateway.utils.Response;
import pl.gsmservice.gateway.utils.Utils;

public class ListSendersResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends List<Sender>> senders;

    @JsonCreator
    public ListSendersResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends List<Sender>> senders) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(senders, "senders");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.senders = senders;
    }

    public ListSendersResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<List<Sender>> senders() {
        return this.senders;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ListSendersResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public ListSendersResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public ListSendersResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public ListSendersResponse withSenders(List<Sender> senders) {
        Utils.checkNotNull(senders, "senders");
        this.senders = Optional.ofNullable(senders);
        return this;
    }

    public ListSendersResponse withSenders(Optional<? extends List<Sender>> senders) {
        Utils.checkNotNull(senders, "senders");
        this.senders = senders;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListSendersResponse other = (ListSendersResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.senders, other.senders);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.senders);
    }

    public String toString() {
        return Utils.toString(ListSendersResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "senders", this.senders);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends List<Sender>> senders = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder senders(List<Sender> senders) {
            Utils.checkNotNull(senders, "senders");
            this.senders = Optional.ofNullable(senders);
            return this;
        }

        public Builder senders(Optional<? extends List<Sender>> senders) {
            Utils.checkNotNull(senders, "senders");
            this.senders = senders;
            return this;
        }

        public ListSendersResponse build() {
            return new ListSendersResponse(this.contentType, this.statusCode, this.rawResponse, this.senders);
        }
    }
}

