/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.operations;

import java.util.Optional;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.models.operations.SendMmsRequestBody;
import pl.gsmservice.gateway.models.operations.SendMmsResponse;
import pl.gsmservice.gateway.operations.SendMms;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;
import pl.gsmservice.gateway.utils.RetryConfig;
import pl.gsmservice.gateway.utils.Utils;

public class SendMmsRequestBuilder {
    private SendMmsRequestBody request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public SendMmsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public SendMmsRequestBuilder request(SendMmsRequestBody request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public SendMmsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public SendMmsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public SendMmsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        SendMms.Sync operation = new SendMms.Sync(this.sdkConfiguration, options, this._headers);
        return (SendMmsResponse)operation.handleResponse(operation.doRequest(this.request));
    }
}

