/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import pl.gsmservice.gateway.models.components.CancelledMessage;
import pl.gsmservice.gateway.utils.AsyncResponse;
import pl.gsmservice.gateway.utils.Blob;
import pl.gsmservice.gateway.utils.Utils;

public class CancelMessagesResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends List<CancelledMessage>> cancelledMessages;
    private Map<String, List<String>> headers;

    @JsonCreator
    public CancelMessagesResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends List<CancelledMessage>> cancelledMessages, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(cancelledMessages, "cancelledMessages");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.cancelledMessages = cancelledMessages;
        this.headers = headers;
    }

    public CancelMessagesResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<List<CancelledMessage>> cancelledMessages() {
        return this.cancelledMessages;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CancelMessagesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public CancelMessagesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public CancelMessagesResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public CancelMessagesResponse withCancelledMessages(List<CancelledMessage> cancelledMessages) {
        Utils.checkNotNull(cancelledMessages, "cancelledMessages");
        this.cancelledMessages = Optional.ofNullable(cancelledMessages);
        return this;
    }

    public CancelMessagesResponse withCancelledMessages(Optional<? extends List<CancelledMessage>> cancelledMessages) {
        Utils.checkNotNull(cancelledMessages, "cancelledMessages");
        this.cancelledMessages = cancelledMessages;
        return this;
    }

    public CancelMessagesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CancelMessagesResponse other = (CancelMessagesResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.cancelledMessages, other.cancelledMessages) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.cancelledMessages, this.headers);
    }

    public String toString() {
        return Utils.toString(CancelMessagesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "cancelledMessages", this.cancelledMessages, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends List<CancelledMessage>> cancelledMessages = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder cancelledMessages(List<CancelledMessage> cancelledMessages) {
            Utils.checkNotNull(cancelledMessages, "cancelledMessages");
            this.cancelledMessages = Optional.ofNullable(cancelledMessages);
            return this;
        }

        public Builder cancelledMessages(Optional<? extends List<CancelledMessage>> cancelledMessages) {
            Utils.checkNotNull(cancelledMessages, "cancelledMessages");
            this.cancelledMessages = cancelledMessages;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public CancelMessagesResponse build() {
            return new CancelMessagesResponse(this.contentType, this.statusCode, this.rawResponse, this.cancelledMessages, this.headers);
        }
    }
}

