/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import pl.gsmservice.gateway.models.components.Price;
import pl.gsmservice.gateway.utils.AsyncResponse;
import pl.gsmservice.gateway.utils.Blob;
import pl.gsmservice.gateway.utils.Utils;

public class GetMmsPriceResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends List<Price>> prices;
    private Map<String, List<String>> headers;

    @JsonCreator
    public GetMmsPriceResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends List<Price>> prices, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(prices, "prices");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.prices = prices;
        this.headers = headers;
    }

    public GetMmsPriceResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<List<Price>> prices() {
        return this.prices;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public GetMmsPriceResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public GetMmsPriceResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public GetMmsPriceResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public GetMmsPriceResponse withPrices(List<Price> prices) {
        Utils.checkNotNull(prices, "prices");
        this.prices = Optional.ofNullable(prices);
        return this;
    }

    public GetMmsPriceResponse withPrices(Optional<? extends List<Price>> prices) {
        Utils.checkNotNull(prices, "prices");
        this.prices = prices;
        return this;
    }

    public GetMmsPriceResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetMmsPriceResponse other = (GetMmsPriceResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.prices, other.prices) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.prices, this.headers);
    }

    public String toString() {
        return Utils.toString(GetMmsPriceResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "prices", this.prices, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends List<Price>> prices = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder prices(List<Price> prices) {
            Utils.checkNotNull(prices, "prices");
            this.prices = Optional.ofNullable(prices);
            return this;
        }

        public Builder prices(Optional<? extends List<Price>> prices) {
            Utils.checkNotNull(prices, "prices");
            this.prices = prices;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public GetMmsPriceResponse build() {
            return new GetMmsPriceResponse(this.contentType, this.statusCode, this.rawResponse, this.prices, this.headers);
        }
    }
}

