/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.http.HttpResponse;
import java.util.Optional;
import pl.gsmservice.gateway.models.components.AccountResponse;
import pl.gsmservice.gateway.utils.AsyncResponse;
import pl.gsmservice.gateway.utils.Blob;
import pl.gsmservice.gateway.utils.Utils;

public class GetSubaccountDetailsResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends AccountResponse> accountResponse;

    @JsonCreator
    public GetSubaccountDetailsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends AccountResponse> accountResponse) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(accountResponse, "accountResponse");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.accountResponse = accountResponse;
    }

    public GetSubaccountDetailsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AccountResponse> accountResponse() {
        return this.accountResponse;
    }

    public static Builder builder() {
        return new Builder();
    }

    public GetSubaccountDetailsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public GetSubaccountDetailsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public GetSubaccountDetailsResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public GetSubaccountDetailsResponse withAccountResponse(AccountResponse accountResponse) {
        Utils.checkNotNull(accountResponse, "accountResponse");
        this.accountResponse = Optional.ofNullable(accountResponse);
        return this;
    }

    public GetSubaccountDetailsResponse withAccountResponse(Optional<? extends AccountResponse> accountResponse) {
        Utils.checkNotNull(accountResponse, "accountResponse");
        this.accountResponse = accountResponse;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetSubaccountDetailsResponse other = (GetSubaccountDetailsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.accountResponse, other.accountResponse);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.accountResponse);
    }

    public String toString() {
        return Utils.toString(GetSubaccountDetailsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "accountResponse", this.accountResponse);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends AccountResponse> accountResponse = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder accountResponse(AccountResponse accountResponse) {
            Utils.checkNotNull(accountResponse, "accountResponse");
            this.accountResponse = Optional.ofNullable(accountResponse);
            return this;
        }

        public Builder accountResponse(Optional<? extends AccountResponse> accountResponse) {
            Utils.checkNotNull(accountResponse, "accountResponse");
            this.accountResponse = accountResponse;
            return this;
        }

        public GetSubaccountDetailsResponse build() {
            return new GetSubaccountDetailsResponse(this.contentType, this.statusCode, this.rawResponse, this.accountResponse);
        }
    }
}

