/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.operations.async;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.models.operations.SetDefaultSenderRequest;
import pl.gsmservice.gateway.models.operations.async.SetDefaultSenderResponse;
import pl.gsmservice.gateway.operations.SetDefaultSender;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;
import pl.gsmservice.gateway.utils.RetryConfig;
import pl.gsmservice.gateway.utils.Utils;

public class SetDefaultSenderRequestBuilder {
    private String sender;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public SetDefaultSenderRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public SetDefaultSenderRequestBuilder sender(String sender) {
        Utils.checkNotNull(sender, "sender");
        this.sender = sender;
        return this;
    }

    public SetDefaultSenderRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public SetDefaultSenderRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private SetDefaultSenderRequest buildRequest() {
        SetDefaultSenderRequest request = new SetDefaultSenderRequest(this.sender);
        return request;
    }

    public CompletableFuture<SetDefaultSenderResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        SetDefaultSender.Async operation = new SetDefaultSender.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), this._headers);
        SetDefaultSenderRequest request = this.buildRequest();
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }
}

