/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.operations;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.SecuritySource;
import pl.gsmservice.gateway.models.errors.SDKError;
import pl.gsmservice.gateway.models.errors.async.ErrorResponse;
import pl.gsmservice.gateway.models.operations.DeleteSenderRequest;
import pl.gsmservice.gateway.models.operations.DeleteSenderResponse;
import pl.gsmservice.gateway.models.operations.async.DeleteSenderResponse;
import pl.gsmservice.gateway.operations.Operations;
import pl.gsmservice.gateway.utils.AsyncRetries;
import pl.gsmservice.gateway.utils.BackoffStrategy;
import pl.gsmservice.gateway.utils.Blob;
import pl.gsmservice.gateway.utils.Exceptions;
import pl.gsmservice.gateway.utils.HTTPClient;
import pl.gsmservice.gateway.utils.HTTPRequest;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Hook;
import pl.gsmservice.gateway.utils.NonRetryableException;
import pl.gsmservice.gateway.utils.Options;
import pl.gsmservice.gateway.utils.Retries;
import pl.gsmservice.gateway.utils.RetryConfig;
import pl.gsmservice.gateway.utils.Utils;

public class DeleteSender {

    public static class Async
    extends Base
    implements Operations.AsyncRequestOperation<DeleteSenderRequest, pl.gsmservice.gateway.models.operations.async.DeleteSenderResponse> {
        private final ScheduledExecutorService retryScheduler;

        public Async(SDKConfiguration sdkConfiguration, Optional<Options> options, ScheduledExecutorService retryScheduler, Headers _headers) {
            super(sdkConfiguration, options, _headers);
            this.retryScheduler = retryScheduler;
        }

        private CompletableFuture<HttpRequest> onBuildRequest(DeleteSenderRequest request) throws Exception {
            HttpRequest req = this.buildRequest(request, DeleteSenderRequest.class);
            return this.sdkConfiguration.asyncHooks().beforeRequest(this.createBeforeRequestContext(), req);
        }

        private CompletableFuture<HttpResponse<Blob>> onError(HttpResponse<Blob> response, Throwable error) {
            return this.sdkConfiguration.asyncHooks().afterError(this.createAfterErrorContext(), response, error);
        }

        private CompletableFuture<HttpResponse<Blob>> onSuccess(HttpResponse<Blob> response) {
            return this.sdkConfiguration.asyncHooks().afterSuccess(this.createAfterSuccessContext(), response);
        }

        @Override
        public CompletableFuture<HttpResponse<Blob>> doRequest(DeleteSenderRequest request) {
            AsyncRetries retries = AsyncRetries.builder().retryConfig(this.retryConfig).statusCodes(this.retryStatusCodes).scheduler(this.retryScheduler).build();
            return retries.retry(() -> ((CompletableFuture)((CompletableFuture)Exceptions.unchecked(() -> this.onBuildRequest(request)).get().thenCompose(this.client::sendAsync)).handle((resp, err) -> {
                if (err != null) {
                    return this.onError(null, (Throwable)err);
                }
                if (Utils.statusCodeMatches(resp.statusCode(), "400", "401", "403", "404", "4XX", "5XX")) {
                    return this.onError((HttpResponse<Blob>)resp, null);
                }
                return CompletableFuture.completedFuture(resp);
            })).thenCompose(Function.identity())).thenCompose(this::onSuccess);
        }

        @Override
        public CompletableFuture<pl.gsmservice.gateway.models.operations.async.DeleteSenderResponse> handleResponse(HttpResponse<Blob> response) {
            String contentType = response.headers().firstValue("Content-Type").orElse("application/octet-stream");
            DeleteSenderResponse.Builder resBuilder = pl.gsmservice.gateway.models.operations.async.DeleteSenderResponse.builder().contentType(contentType).statusCode(response.statusCode()).rawResponse(response);
            pl.gsmservice.gateway.models.operations.async.DeleteSenderResponse res = resBuilder.build();
            if (Utils.statusCodeMatches(response.statusCode(), "204")) {
                res.withHeaders(response.headers().map());
                return CompletableFuture.completedFuture(res);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "400", "401", "403", "404", "4XX")) {
                if (Utils.contentTypeMatches(contentType, "application/problem+json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        ErrorResponse out;
                        try {
                            out = (ErrorResponse)Utils.mapper().readValue(bodyBytes, (TypeReference)new TypeReference<ErrorResponse>(){});
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "5XX")) {
                if (Utils.contentTypeMatches(contentType, "application/problem+json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        ErrorResponse out;
                        try {
                            out = (ErrorResponse)Utils.mapper().readValue(bodyBytes, (TypeReference)new TypeReference<ErrorResponse>(){});
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            return Utils.createAsyncApiError(response, "Unexpected status code received: " + response.statusCode());
        }
    }

    public static class Sync
    extends Base
    implements Operations.RequestOperation<DeleteSenderRequest, DeleteSenderResponse> {
        public Sync(SDKConfiguration sdkConfiguration, Optional<Options> options, Headers _headers) {
            super(sdkConfiguration, options, _headers);
        }

        private HttpRequest onBuildRequest(DeleteSenderRequest request) throws Exception {
            HttpRequest req = this.buildRequest(request, DeleteSenderRequest.class);
            return this.sdkConfiguration.hooks().beforeRequest(this.createBeforeRequestContext(), req);
        }

        private HttpResponse<InputStream> onError(HttpResponse<InputStream> response, Exception error) throws Exception {
            return this.sdkConfiguration.hooks().afterError(this.createAfterErrorContext(), Optional.ofNullable(response), Optional.ofNullable(error));
        }

        private HttpResponse<InputStream> onSuccess(HttpResponse<InputStream> response) throws Exception {
            return this.sdkConfiguration.hooks().afterSuccess(this.createAfterSuccessContext(), response);
        }

        @Override
        public HttpResponse<InputStream> doRequest(DeleteSenderRequest request) throws Exception {
            Retries retries = Retries.builder().action(() -> {
                HttpRequest r;
                try {
                    r = this.onBuildRequest(request);
                }
                catch (Exception e) {
                    throw new NonRetryableException(e);
                }
                try {
                    HttpResponse<InputStream> httpRes = this.client.send(r);
                    if (Utils.statusCodeMatches(httpRes.statusCode(), "400", "401", "403", "404", "4XX", "5XX")) {
                        return this.onError(httpRes, null);
                    }
                    return httpRes;
                }
                catch (Exception e) {
                    return this.onError(null, e);
                }
            }).retryConfig(this.retryConfig).statusCodes(this.retryStatusCodes).build();
            return this.onSuccess(retries.run());
        }

        @Override
        public DeleteSenderResponse handleResponse(HttpResponse<InputStream> response) throws Exception {
            String contentType = response.headers().firstValue("Content-Type").orElse("application/octet-stream");
            DeleteSenderResponse.Builder resBuilder = DeleteSenderResponse.builder().contentType(contentType).statusCode(response.statusCode()).rawResponse(response);
            DeleteSenderResponse res = resBuilder.build();
            if (Utils.statusCodeMatches(response.statusCode(), "204")) {
                res.withHeaders(response.headers().map());
                return res;
            }
            if (Utils.statusCodeMatches(response.statusCode(), "400", "401", "403", "404", "4XX")) {
                if (Utils.contentTypeMatches(contentType, "application/problem+json")) {
                    pl.gsmservice.gateway.models.errors.ErrorResponse out = (pl.gsmservice.gateway.models.errors.ErrorResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<pl.gsmservice.gateway.models.errors.ErrorResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "5XX")) {
                if (Utils.contentTypeMatches(contentType, "application/problem+json")) {
                    pl.gsmservice.gateway.models.errors.ErrorResponse out = (pl.gsmservice.gateway.models.errors.ErrorResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<pl.gsmservice.gateway.models.errors.ErrorResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            throw new SDKError(response, response.statusCode(), "Unexpected status code received: " + response.statusCode(), Utils.extractByteArrayFromBody(response));
        }
    }

    static abstract class Base {
        final SDKConfiguration sdkConfiguration;
        final String baseUrl;
        final SecuritySource securitySource;
        final List<String> retryStatusCodes;
        final RetryConfig retryConfig;
        final HTTPClient client;
        final Headers _headers;

        public Base(SDKConfiguration sdkConfiguration, Optional<Options> options, Headers _headers) {
            this.sdkConfiguration = sdkConfiguration;
            this._headers = _headers;
            this.baseUrl = this.sdkConfiguration.serverUrl();
            this.securitySource = this.sdkConfiguration.securitySource();
            options.ifPresent(o -> o.validate(List.of(Options.Option.RETRY_CONFIG)));
            this.retryStatusCodes = List.of("5XX");
            this.retryConfig = options.flatMap(Options::retryConfig).or(sdkConfiguration::retryConfig).orElse(RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
            this.client = this.sdkConfiguration.client();
        }

        Optional<SecuritySource> securitySource() {
            return Optional.ofNullable(this.securitySource);
        }

        Hook.BeforeRequestContextImpl createBeforeRequestContext() {
            return new Hook.BeforeRequestContextImpl(this.sdkConfiguration, this.baseUrl, "deleteSender", Optional.of(List.of()), this.securitySource());
        }

        Hook.AfterSuccessContextImpl createAfterSuccessContext() {
            return new Hook.AfterSuccessContextImpl(this.sdkConfiguration, this.baseUrl, "deleteSender", Optional.of(List.of()), this.securitySource());
        }

        Hook.AfterErrorContextImpl createAfterErrorContext() {
            return new Hook.AfterErrorContextImpl(this.sdkConfiguration, this.baseUrl, "deleteSender", Optional.of(List.of()), this.securitySource());
        }

        <T> HttpRequest buildRequest(T request, Class<T> klass) throws Exception {
            String url = Utils.generateURL(klass, this.baseUrl, "/senders/{sender}", request, null);
            HTTPRequest req = new HTTPRequest(url, "DELETE");
            req.addHeader("Accept", "application/problem+json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
            this._headers.forEach((k, list) -> list.forEach(v -> req.addHeader((String)k, (String)v)));
            Utils.configureSecurity(req, this.sdkConfiguration.securitySource().getSecurity());
            return req.build();
        }
    }
}

