/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.utils;

import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import pl.gsmservice.gateway.utils.Blob;
import pl.gsmservice.gateway.utils.Helpers;
import pl.gsmservice.gateway.utils.Hook;

public final class AsyncHook {
    private AsyncHook() {
    }

    public static final class IdempotencyHook
    implements BeforeRequest {
        @Override
        public CompletableFuture<HttpRequest> beforeRequest(Hook.BeforeRequestContext context, HttpRequest request) {
            HttpRequest.Builder b = Helpers.copy(request);
            b.header("Idempotency-Key", UUID.randomUUID().toString());
            return CompletableFuture.completedFuture(b.build());
        }
    }

    @FunctionalInterface
    public static interface AfterError {
        public static final AfterError DEFAULT = (context, response, error) -> Optional.ofNullable(response).map(CompletableFuture::completedFuture).orElse(CompletableFuture.failedFuture(error));

        public CompletableFuture<HttpResponse<Blob>> afterError(Hook.AfterErrorContext var1, HttpResponse<Blob> var2, Throwable var3);
    }

    @FunctionalInterface
    public static interface AfterSuccess {
        public static final AfterSuccess DEFAULT = (context, response) -> CompletableFuture.completedFuture(response);

        public CompletableFuture<HttpResponse<Blob>> afterSuccess(Hook.AfterSuccessContext var1, HttpResponse<Blob> var2);
    }

    @FunctionalInterface
    public static interface BeforeRequest {
        public static final BeforeRequest DEFAULT = (context, request) -> CompletableFuture.completedFuture(request);

        public CompletableFuture<HttpRequest> beforeRequest(Hook.BeforeRequestContext var1, HttpRequest var2);
    }
}

