/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.utils;

import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import pl.gsmservice.gateway.utils.AsyncHook;
import pl.gsmservice.gateway.utils.Blob;
import pl.gsmservice.gateway.utils.Exceptions;
import pl.gsmservice.gateway.utils.Hook;
import pl.gsmservice.gateway.utils.Hooks;
import pl.gsmservice.gateway.utils.Utils;

public class AsyncHooks
implements AsyncHook.BeforeRequest,
AsyncHook.AfterSuccess,
AsyncHook.AfterError {
    private final List<AsyncHook.BeforeRequest> beforeRequestHooks = new CopyOnWriteArrayList<AsyncHook.BeforeRequest>();
    private final List<AsyncHook.AfterSuccess> afterSuccessHooks = new CopyOnWriteArrayList<AsyncHook.AfterSuccess>();
    private final List<AsyncHook.AfterError> afterErrorHooks = new CopyOnWriteArrayList<AsyncHook.AfterError>();

    public AsyncHooks registerBeforeRequest(AsyncHook.BeforeRequest beforeRequest) {
        Utils.checkNotNull(beforeRequest, "beforeRequest");
        this.beforeRequestHooks.add(beforeRequest);
        return this;
    }

    public AsyncHooks registerAfterSuccess(AsyncHook.AfterSuccess afterSuccess) {
        Utils.checkNotNull(afterSuccess, "afterSuccess");
        this.afterSuccessHooks.add(afterSuccess);
        return this;
    }

    public AsyncHooks registerAfterError(AsyncHook.AfterError afterError) {
        Utils.checkNotNull(afterError, "afterError");
        this.afterErrorHooks.add(afterError);
        return this;
    }

    @Override
    public CompletableFuture<HttpRequest> beforeRequest(Hook.BeforeRequestContext context, HttpRequest request) {
        Utils.checkNotNull(context, "context");
        Utils.checkNotNull(request, "request");
        CompletionStage<HttpRequest> result = CompletableFuture.completedFuture(request);
        for (AsyncHook.BeforeRequest hook : this.beforeRequestHooks) {
            result = result.thenCompose(req -> hook.beforeRequest(context, (HttpRequest)req));
        }
        return result;
    }

    @Override
    public CompletableFuture<HttpResponse<Blob>> afterSuccess(Hook.AfterSuccessContext context, HttpResponse<Blob> response) {
        Utils.checkNotNull(context, "context");
        Utils.checkNotNull(response, "response");
        CompletionStage<HttpResponse<Blob>> result = CompletableFuture.completedFuture(response);
        for (AsyncHook.AfterSuccess hook : this.afterSuccessHooks) {
            result = ((CompletableFuture)result.handle((resp, ex) -> hook.afterSuccess(context, (HttpResponse<Blob>)resp).thenApply(hookResp -> {
                if (hookResp == null) {
                    throw new IllegalStateException("afterSuccess must return a non-null response");
                }
                return hookResp;
            }))).thenCompose(future -> future);
        }
        return result;
    }

    @Override
    public CompletableFuture<HttpResponse<Blob>> afterError(Hook.AfterErrorContext context, HttpResponse<Blob> response, Throwable error) {
        Utils.checkNotNull(context, "context");
        Utils.checkArgument(response != null ^ error != null, "one and only one of response or error must be present");
        CompletionStage<HttpResponse<Blob>> result = response != null ? CompletableFuture.completedFuture(response) : CompletableFuture.failedFuture(error);
        AtomicBoolean failedEarly = new AtomicBoolean(false);
        for (AsyncHook.AfterError hook : this.afterErrorHooks) {
            result = ((CompletableFuture)result.handle((resp, ex) -> {
                if (failedEarly.get()) {
                    throw (Hooks.FailEarlyException)ex;
                }
                return hook.afterError(context, (HttpResponse<Blob>)resp, (Throwable)ex).handle((hookResp, hookErr) -> {
                    if (hookErr != null) {
                        if (hookErr instanceof Hooks.FailEarlyException) {
                            failedEarly.set(true);
                            throw (Hooks.FailEarlyException)hookErr;
                        }
                        throw Exceptions.unchecked(hookErr);
                    }
                    if (hookResp == null) {
                        throw new IllegalStateException("afterError must either throw an exception or return a non-null response");
                    }
                    return hookResp;
                });
            })).thenCompose(future -> future);
        }
        return result;
    }
}

