/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.utils;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class BigDecimalString {
    private final BigDecimal value;

    public BigDecimalString(BigDecimal value) {
        this.value = value;
    }

    public BigDecimalString(String value) {
        this(new BigDecimal(value));
    }

    public BigDecimal value() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigDecimalString other = (BigDecimalString)obj;
        return Objects.equals(this.value, other.value);
    }

    public static final class Deserializer
    extends StdDeserializer<BigDecimalString> {
        protected Deserializer() {
            super(BigDecimalString.class);
        }

        public BigDecimalString deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String s = (String)p.readValueAs(String.class);
            return new BigDecimalString(new BigDecimal(s));
        }
    }

    public static final class Serializer
    extends StdSerializer<BigDecimalString> {
        protected Serializer() {
            super(BigDecimalString.class);
        }

        public void serialize(BigDecimalString value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeString(value.value.toString());
        }
    }
}

