/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.utils;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import pl.gsmservice.gateway.utils.EventStreamMessage;
import pl.gsmservice.gateway.utils.StreamingParser;

public final class BlockingParser<T> {
    private final Reader reader;
    private final StreamingParser<T> parser;
    private final char[] readBuffer = new char[8192];
    private boolean readerExhausted = false;

    public BlockingParser(Reader reader, StreamingParser<T> parser) {
        this.reader = reader;
        this.parser = parser;
    }

    public Optional<T> next() throws IOException {
        int bytesRead;
        Optional<T> result = this.parser.next();
        if (result.isPresent()) {
            return result;
        }
        if (this.readerExhausted) {
            return this.parser.finish();
        }
        while ((bytesRead = this.reader.read(this.readBuffer)) != -1) {
            ByteBuffer chunk = ByteBuffer.wrap(new String(this.readBuffer, 0, bytesRead).getBytes(StandardCharsets.UTF_8));
            result = this.parser.add(chunk);
            if (!result.isPresent()) continue;
            return result;
        }
        this.readerExhausted = true;
        return this.parser.finish();
    }

    public boolean hasNext() throws IOException {
        return this.parser.hasBufferedData() || !this.readerExhausted;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public static BlockingParser<String> forJsonLines(Reader reader) {
        return new BlockingParser<String>(reader, StreamingParser.forJsonLines());
    }

    public static BlockingParser<EventStreamMessage> forSSE(Reader reader) {
        return new BlockingParser<EventStreamMessage>(reader, StreamingParser.forSSE());
    }
}

