/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.utils;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Exceptions {
    public static Exception coerceException(Throwable throwable) {
        if (throwable instanceof Exception) {
            return (Exception)throwable;
        }
        return new Exception(throwable);
    }

    public static RuntimeException unchecked(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof IOException) {
            throw new UncheckedIOException((IOException)t);
        }
        throw new RuntimeException(t);
    }

    public static <T> T rethrow(Throwable e) {
        throw Exceptions.unchecked(e);
    }

    public static <T, R> Function<T, R> unchecked(CheckedFunction<T, R> fn) {
        return t -> {
            try {
                return fn.apply(t);
            }
            catch (Exception e) {
                throw Exceptions.unchecked(e);
            }
        };
    }

    public static <T> Supplier<T> unchecked(CheckedSupplier<T> supplier) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Exception e) {
                throw Exceptions.unchecked(e);
            }
        };
    }

    public static <T> Consumer<T> unchecked(CheckedConsumer<T> consumer) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception e) {
                throw Exceptions.unchecked(e);
            }
        };
    }

    public static Runnable unchecked(CheckedRunnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                throw Exceptions.unchecked(e);
            }
        };
    }

    @FunctionalInterface
    public static interface CheckedRunnable {
        public void run() throws Exception;
    }

    @FunctionalInterface
    public static interface CheckedConsumer<T> {
        public void accept(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface CheckedSupplier<T> {
        public T get() throws Exception;
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

