/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import pl.gsmservice.gateway.utils.Utils;

public final class Headers {
    public static final Headers EMPTY = new Headers(Collections.emptyMap());
    private final Map<String, List<String>> map;

    public Headers(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.map = headers.entrySet().stream().map(entry -> Map.entry(((String)entry.getKey()).toLowerCase(Locale.ENGLISH), (List)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Headers() {
        this(new HashMap<String, List<String>>());
    }

    public List<String> get(String name) {
        Utils.checkNotNull(name, "name");
        return Collections.unmodifiableList(this.values(name));
    }

    public Optional<String> first(String name) {
        Utils.checkNotNull(name, "name");
        return this.values(name).stream().findFirst();
    }

    public Headers add(String name, String value) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(value, "value");
        List<String> values = this.values(name);
        if (values.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(value);
            this.map.put(name.toLowerCase(Locale.ENGLISH), list);
        } else {
            values.add(value);
        }
        return this;
    }

    public Headers add(Headers headers) {
        Utils.checkNotNull(headers, "headers");
        headers.forEach((key, values) -> values.forEach((? super T value) -> this.add((String)key, (String)value)));
        return this;
    }

    public void forEach(BiConsumer<? super String, ? super List<String>> consumer) {
        Utils.checkNotNull(consumer, "consumer");
        this.map.forEach(consumer);
    }

    public Map<String, List<String>> map() {
        return this.map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ArrayList((Collection)entry.getValue())));
    }

    private List<String> values(String name) {
        return this.map.getOrDefault(name.toLowerCase(Locale.ENGLISH), List.of());
    }

    public String toString() {
        return "Headers[ " + this.map.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + String.valueOf(entry.getValue())).collect(Collectors.joining(", ")) + "]";
    }
}

