/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.UnaryOperator;
import pl.gsmservice.gateway.utils.HTTPClient;
import pl.gsmservice.gateway.utils.SpeakeasyHTTPClient;

public final class RecordingClient
implements HTTPClient {
    private final List<HttpRequest> requests = new CopyOnWriteArrayList<HttpRequest>();
    private final HTTPClient client;
    private final List<UnaryOperator<HttpRequest>> beforeRequestHooks = new ArrayList<UnaryOperator<HttpRequest>>();
    private final List<UnaryOperator<HttpResponse<InputStream>>> afterResponseHooks = new ArrayList<UnaryOperator<HttpResponse<InputStream>>>();

    public RecordingClient() {
        this.client = new SpeakeasyHTTPClient();
    }

    @Override
    public HttpResponse<InputStream> send(HttpRequest request) throws IOException, InterruptedException, URISyntaxException {
        for (UnaryOperator<HttpRequest> hook : this.beforeRequestHooks) {
            request = (HttpRequest)hook.apply(request);
        }
        this.requests.add(request);
        HttpResponse response = this.client.send(request);
        for (UnaryOperator<HttpResponse<InputStream>> hook : this.afterResponseHooks) {
            response = (HttpResponse)hook.apply(response);
        }
        return response;
    }

    public List<HttpRequest> requests() {
        return this.requests;
    }

    public RecordingClient beforeRequest(UnaryOperator<HttpRequest> hook) {
        this.beforeRequestHooks.add(hook);
        return this;
    }

    public RecordingClient afterResponse(UnaryOperator<HttpResponse<InputStream>> hook) {
        this.afterResponseHooks.add(hook);
        return this;
    }

    public void reset() {
        this.requests.clear();
    }
}

