/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.utils;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import java.util.function.Function;
import javax.net.ssl.SSLSession;

public class ResponseWithBody<R, B>
implements HttpResponse<B> {
    private final HttpResponse<R> original;
    private final Function<R, B> bodyMapper;
    private final B body;

    public ResponseWithBody(HttpResponse<R> original, Function<R, B> bodyMapper) {
        this.original = original;
        this.bodyMapper = bodyMapper;
        this.body = bodyMapper.apply(original.body());
    }

    public ResponseWithBody(HttpResponse<R> original, B body) {
        this.original = original;
        this.body = body;
        this.bodyMapper = null;
    }

    @Override
    public int statusCode() {
        return this.original.statusCode();
    }

    @Override
    public HttpRequest request() {
        return this.original.request();
    }

    @Override
    public Optional<HttpResponse<B>> previousResponse() {
        return this.original.previousResponse().map(prev -> new ResponseWithBody<R, Function<R, B>>(prev, this.bodyMapper));
    }

    @Override
    public HttpHeaders headers() {
        return this.original.headers();
    }

    @Override
    public B body() {
        return this.body;
    }

    @Override
    public Optional<SSLSession> sslSession() {
        return this.original.sslSession();
    }

    @Override
    public URI uri() {
        return this.original.uri();
    }

    @Override
    public HttpClient.Version version() {
        return this.original.version();
    }
}

