package lols.core.common

import java.lang.reflect.InvocationHandler
import java.lang.reflect.Method
import java.lang.reflect.Proxy

class ServiceProxyFactory[T](serviceClass: Class[T], methodCallSerializer: MethodCallSerializer, metadataResolver: MetaDataResolver) {

  def create: T =
    Proxy.newProxyInstance(serviceClass.getClassLoader, Array(serviceClass), serviceCallHandler).asInstanceOf[T]

  val serviceCallHandler = new InvocationHandler {

    def invoke(proxy: AnyRef, method: Method, args: Array[AnyRef]): AnyRef = {
      return methodCallSerializer.serializeCall(new MethodCall(serviceClass.getName, method.getName, args, metadataResolver.getMetadata))
    }

  }

}

