package lols.core.common

import scalapi.lang.Implicits._

class ThreadLocalMetaDataResolver extends MetaDataResolver with MetaDataProvider {

  val metaData = Map[String, String]().asThreadLocal

  def setMetaData(key: String, value: String) =
    metaData.replace {
      _ + (key -> value)
    }

  def getMetadata: Array[MetaDataPair] =
    metaData.get.map(kv => new MetaDataPair(kv._1, kv._2)).toArray

}