package pl.iogreen.scalapi.data


abstract class EntityStore(queryHandlers: List[PartialFunction[AnyRef, List[Any]]]) {

  val empty: PartialFunction[AnyRef, List[Any]] = Map.empty

  val queryHandlersChain: PartialFunction[AnyRef, List[Any]] =
    queryHandlers.foldLeft(empty)((chain, handler) => chain orElse handler)

  def store(entity: Entity[_])

  def load[I, E <: Entity[I]](clazz: Class[E], id: I): Option[E]

  def delete[I, E <: Entity[I]](clazz: Class[E], id: I)

  def delete(entity: Entity[_])

  def query[E](query: AnyRef): List[E] =
    queryHandlersChain(query) match {
      case list: List[E] => list
      case _ => Nil
    }

}