package scalapi.io

import java.io.InputStream
import org.apache.commons.io.IOUtils
import scalapi.lang.{ThreadCodec, Control}

class InputStreamPimp[IS <: InputStream](source: IS) {

  def use[R](streamProcessor: IS => R): R =
    Control.use(source)(streamProcessor)

  def asString(): String =
    IOUtils.toString(source, ThreadCodec.current().name())

}
