package scalapi.lang

import java.lang.ThreadLocal
import javax.annotation.Nullable

/**
 * Enhancements for scala.Any instances.
 *
 * @param t
 *  type of instance being pimped.
 */
class AnyPimp[T](@Nullable t: T) {

  /**
   * Evaluates block of code on instance and returns it.
   */
  def evaluate(evaluation: T => Any): T =
    Control.evaluate(t)(evaluation)

  /**
   * Evaluates block of code on instance and returns the results.
   */
  def mapTo[R](mapping: T => R): R =
    Control.mapTo(t)(mapping)

  /**
   * Wraps instance into java.lang.ThreadLocal.
   */
  def asThreadLocal: ThreadLocal[T] =
    Control.evaluate(new ThreadLocal[T]) {
      _.set(t)
    }

}