package scalapi.lang

import Implicits._

class ArrayPimp[T](array: Array[T]) {

  array.assertNotNull()

  def shallowCopy()(implicit manifest: Manifest[T]): Array[T] = {
    manifest.assertNotNull()

    new Array[T](array.length).evaluate {
      System.arraycopy(array, 0, _, 0, array.length)
    }
  }

}

