package scalapi.lang

import collection.mutable.ListBuffer
import Implicits._

object Control {

  def evaluate[T](t: T)(evaluation: T => Any): T = {
    evaluation(t)
    t
  }

  def mapTo[T, R](t: T)(mapping: T => R): R =
    mapping(t)

  def use[CLOSEABLE <: {def close()}, RETURN_TYPE]
  (closeable: CLOSEABLE)
  (closeableProcessor: CLOSEABLE => RETURN_TYPE): RETURN_TYPE = {
    try {
      closeableProcessor(closeable)
    } finally {
      closeable.close()
    }
  }

  def collectWhile[R](test: => Boolean)(block: => R): List[R] =
    new ListBuffer[R].evaluate {
      buffer =>
        while (test) buffer += block
    }.toList

}
