package scalapi.lang

import java.nio.charset.Charset
import Implicits._

object ThreadCodec {

  private val defaultCharset = Charset.forName("UTF-8")

  private val threadCodec = defaultCharset.asThreadLocal

  def current(): Charset =
    threadCodec.get

  def change(charset: Charset) {
    threadCodec.set(charset)
  }

  def rollback() {
    threadCodec.set(defaultCharset)
  }

  def withEncoding(charset: Charset)(encodedBlock: Unit) {
    change(charset)
    encodedBlock
    rollback()
  }

}