package scalapi.lang

import scalapi.lang.Implicits._

class TransformationChannel(defaultTransformation: PartialFunction[Any, Any]) {

  var preTransformations: List[PartialFunction[Any, Object]] = List()

  def transform[T <: Object](any: Any): T = {
    preTransformations.foldLeft(any) {
      (value, transformation) => if (transformation.isDefinedAt(value)) transformation(value) else value
    } mapTo {
      defaultTransformation(_)
    } match {
      case t: T => t
    }
  }

  def addPreTransformation(preTransformation: PartialFunction[Any, Object]) {
    preTransformations = preTransformations ::: List(preTransformation)
  }

}

object TransformationChannel {

  def apply(defaultTransformation: PartialFunction[Any, Any]) =
    new TransformationChannel(defaultTransformation)

}