/*
 * Decompiled with CFR 0.152.
 */
package pl.iterators.baklava.http4s;

import cats.Functor;
import cats.MonadError;
import cats.data.Kleisli;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.IOPlatform;
import cats.effect.kernel.GenConcurrent;
import cats.effect.unsafe.IORuntime;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import org.http4s.EntityDecoder;
import org.http4s.EntityDecoder$;
import org.http4s.EntityEncoder;
import org.http4s.EntityEncoder$;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpVersion;
import org.http4s.HttpVersion$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Request;
import org.http4s.Request$;
import org.http4s.Response;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.UrlForm;
import org.http4s.UrlForm$;
import org.http4s.headers.Content$minusType$;
import org.typelevel.ci.CIString$;
import org.typelevel.vault.Vault;
import pl.iterators.baklava.BaklavaAssertionException;
import pl.iterators.baklava.BaklavaHttpDsl;
import pl.iterators.baklava.BaklavaHttpHeaders;
import pl.iterators.baklava.BaklavaHttpHeaders$;
import pl.iterators.baklava.BaklavaHttpMethod;
import pl.iterators.baklava.BaklavaHttpMethod$;
import pl.iterators.baklava.BaklavaHttpProtocol;
import pl.iterators.baklava.BaklavaHttpProtocol$;
import pl.iterators.baklava.BaklavaHttpStatus;
import pl.iterators.baklava.BaklavaHttpStatus$;
import pl.iterators.baklava.BaklavaRequestContext;
import pl.iterators.baklava.BaklavaResponseContext;
import pl.iterators.baklava.BaklavaResponseContext$;
import pl.iterators.baklava.BaklavaTestFrameworkDsl;
import pl.iterators.baklava.EmptyBody;
import pl.iterators.baklava.EmptyBodyInstance$;
import pl.iterators.baklava.FormOf;
import pl.iterators.baklava.FreeFormSchema$;
import pl.iterators.baklava.Schema;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public interface BaklavaHttp4s<TestFrameworkFragmentType, TestFrameworkFragmentsType, TestFrameworkExecutionType>
extends BaklavaHttpDsl<Kleisli<?, Request<IO>, Response<IO>>, EntityEncoder<IO, Object>, EntityDecoder<IO, Object>, TestFrameworkFragmentType, TestFrameworkFragmentsType, TestFrameworkExecutionType> {
    public static void $init$(BaklavaHttp4s $this) {
        $this.pl$iterators$baklava$http4s$BaklavaHttp4s$_setter_$urlFormSchema_$eq((Schema)FreeFormSchema$.MODULE$.apply("UrlForm"));
    }

    public static EntityEncoder emptyToRequestBodyType$(BaklavaHttp4s $this) {
        return $this.emptyToRequestBodyType();
    }

    default public EntityEncoder<IO, EmptyBody> emptyToRequestBodyType() {
        return EntityEncoder$.MODULE$.unitEncoder().contramap((Function1)(JProcedure1 & Serializable)_$2 -> {});
    }

    public static EntityEncoder formUrlencodedToRequestBodyType$(BaklavaHttp4s $this) {
        return $this.formUrlencodedToRequestBodyType();
    }

    default public <T> EntityEncoder<IO, FormOf<T>> formUrlencodedToRequestBodyType() {
        return ((EntityEncoder)Predef$.MODULE$.implicitly((Object)UrlForm$.MODULE$.entityEncoder(UrlForm$.MODULE$.entityEncoder$default$1()))).contramap((Function1 & Serializable)formUrlEncoded -> new UrlForm(UrlForm$.MODULE$.apply(formUrlEncoded.fields())));
    }

    public Schema<Map> urlFormSchema();

    public void pl$iterators$baklava$http4s$BaklavaHttp4s$_setter_$urlFormSchema_$eq(Schema var1);

    public static EntityDecoder emptyToResponseBodyType$(BaklavaHttp4s $this) {
        return $this.emptyToResponseBodyType();
    }

    default public EntityDecoder<IO, EmptyBody> emptyToResponseBodyType() {
        return EntityDecoder$.MODULE$.void((GenConcurrent)IO$.MODULE$.asyncForIO()).map((Function1 & Serializable)_$3 -> EmptyBodyInstance$.MODULE$, (Functor)IO$.MODULE$.asyncForIO());
    }

    public static BaklavaHttpStatus statusCodeToBaklavaStatusCodes$(BaklavaHttp4s $this, Status statusCode) {
        return $this.statusCodeToBaklavaStatusCodes(statusCode);
    }

    default public BaklavaHttpStatus statusCodeToBaklavaStatusCodes(Status statusCode) {
        return BaklavaHttpStatus$.MODULE$.apply(statusCode.code());
    }

    public static Status baklavaStatusCodeToStatusCode$(BaklavaHttp4s $this, BaklavaHttpStatus baklavaHttpStatus) {
        return $this.baklavaStatusCodeToStatusCode(baklavaHttpStatus);
    }

    default public Status baklavaStatusCodeToStatusCode(BaklavaHttpStatus baklavaHttpStatus) {
        return (Status)Status$.MODULE$.fromInt(baklavaHttpStatus.status()).getOrElse(() -> BaklavaHttp4s.baklavaStatusCodeToStatusCode$$anonfun$1(baklavaHttpStatus));
    }

    public static BaklavaHttpMethod httpMethodToBaklavaHttpMethod$(BaklavaHttp4s $this, Method method) {
        return $this.httpMethodToBaklavaHttpMethod(method);
    }

    default public BaklavaHttpMethod httpMethodToBaklavaHttpMethod(Method method) {
        return BaklavaHttpMethod$.MODULE$.apply(method.name());
    }

    public static Method baklavaHttpMethodToHttpMethod$(BaklavaHttp4s $this, BaklavaHttpMethod baklavaHttpMethod) {
        return $this.baklavaHttpMethodToHttpMethod(baklavaHttpMethod);
    }

    default public Method baklavaHttpMethodToHttpMethod(BaklavaHttpMethod baklavaHttpMethod) {
        return (Method)Method$.MODULE$.fromString(baklavaHttpMethod.value()).getOrElse(() -> BaklavaHttp4s.baklavaHttpMethodToHttpMethod$$anonfun$1(baklavaHttpMethod));
    }

    public static HttpVersion baklavaHttpProtocolToHttpProtocol$(BaklavaHttp4s $this, BaklavaHttpProtocol baklavaHttpProtocol) {
        return $this.baklavaHttpProtocolToHttpProtocol(baklavaHttpProtocol);
    }

    default public HttpVersion baklavaHttpProtocolToHttpProtocol(BaklavaHttpProtocol baklavaHttpProtocol) {
        String string = baklavaHttpProtocol.protocol();
        switch (string == null ? 0 : string.hashCode()) {
            case 649368564: {
                if (!"HTTP/0.9".equals(string)) break;
                return HttpVersion$.MODULE$.HTTP$div0$u002E9();
            }
            case 649369516: {
                if (!"HTTP/1.0".equals(string)) break;
                return HttpVersion$.MODULE$.HTTP$div1$u002E0();
            }
            case 649369517: {
                if (!"HTTP/1.1".equals(string)) break;
                return HttpVersion$.MODULE$.HTTP$div1$u002E1();
            }
            case 649370477: {
                if (!"HTTP/2.0".equals(string)) break;
                return HttpVersion$.MODULE$.HTTP$div2();
            }
            case 2141455468: {
                if (!"HTTP/3".equals(string)) break;
                return HttpVersion$.MODULE$.HTTP$div3();
            }
        }
        throw new IllegalStateException(new StringBuilder(18).append("Invalid protocol: ").append(baklavaHttpProtocol.protocol()).toString());
    }

    public static BaklavaHttpProtocol httpProtocolToBaklavaHttpProtocol$(BaklavaHttp4s $this, HttpVersion protocol) {
        return $this.httpProtocolToBaklavaHttpProtocol(protocol);
    }

    default public BaklavaHttpProtocol httpProtocolToBaklavaHttpProtocol(HttpVersion protocol) {
        return BaklavaHttpProtocol$.MODULE$.apply(protocol.toString());
    }

    public static List baklavaHeadersToHttpHeaders$(BaklavaHttp4s $this, BaklavaHttpHeaders headers) {
        return $this.baklavaHeadersToHttpHeaders(headers);
    }

    default public List baklavaHeadersToHttpHeaders(BaklavaHttpHeaders headers) {
        return Headers$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.scalaCollectionSeqToRaw((Seq)((IterableOnceOps)headers.headers().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return Header.Raw$.MODULE$.apply(CIString$.MODULE$.apply(k), v);
            }
            throw new MatchError((Object)tuple2);
        })).toList(), (Function1 & Serializable)h -> Header.ToRaw$.MODULE$.rawToRaw(h))}));
    }

    public static BaklavaHttpHeaders httpHeadersToBaklavaHeaders$(BaklavaHttp4s $this, List headers) {
        return $this.httpHeadersToBaklavaHeaders(headers);
    }

    default public BaklavaHttpHeaders httpHeadersToBaklavaHeaders(List headers) {
        return BaklavaHttpHeaders$.MODULE$.apply(headers.map((Function1 & Serializable)h -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)h.name().toString());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)h.value());
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public static BaklavaResponseContext httpResponseToBaklavaResponseContext$(BaklavaHttp4s $this, Request request, Response response, EntityDecoder evidence$1, ClassTag evidence$2) {
        return $this.httpResponseToBaklavaResponseContext((Request<IO>)request, (Response<IO>)response, evidence$1, evidence$2);
    }

    default public <T> BaklavaResponseContext<T, Request<IO>, Response<IO>> httpResponseToBaklavaResponseContext(Request<IO> request, Response<IO> response, EntityDecoder<IO, T> evidence$1, ClassTag<T> evidence$2) {
        Vector requestBytes = (Vector)((IOPlatform)request.body().compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).toVector()).unsafeRunSync(this.runtime());
        String requestString = new String((byte[])requestBytes.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), "UTF-8");
        Request newRequest = (Request)request.withBodyStream(Stream$.MODULE$.emits((Seq)requestBytes));
        Vector responseBytes = (Vector)((IOPlatform)response.body().compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).toVector()).unsafeRunSync(this.runtime());
        String responseString = new String((byte[])responseBytes.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), "UTF-8");
        Response newResponse = (Response)response.withBodyStream(Stream$.MODULE$.emits((Seq)responseBytes));
        Try try_ = Try$.MODULE$.apply(() -> this.httpResponseToBaklavaResponseContext$$anonfun$1(newResponse, evidence$1));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                throw new BaklavaAssertionException(new StringBuilder(33).append("Failed to decode response body: ").append(exception.getMessage()).append("\n").append(new StringBuilder(25).append("Expected: ").append(((ClassTag)Predef$.MODULE$.implicitly(evidence$2)).runtimeClass().getSimpleName()).append(", but got: ").append(response.status().code()).append(" -> ").append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(responseString), ((BaklavaTestFrameworkDsl)this).maxBodyLengthInAssertion())).toString()).toString());
            }
            throw new MatchError((Object)try_);
        }
        Object value = ((Success)try_).value();
        return BaklavaResponseContext$.MODULE$.apply(this.httpProtocolToBaklavaHttpProtocol(response.httpVersion()), this.statusCodeToBaklavaStatusCodes(response.status()), this.httpHeadersToBaklavaHeaders(response.headers()), value, (Object)newRequest, requestString, (Object)newResponse, responseString, Headers$.MODULE$.get$extension(request.headers(), Header.Select$.MODULE$.singleHeaders(Content$minusType$.MODULE$.headerInstance())).map((Function1 & Serializable)ct -> new StringBuilder(1).append(ct.mediaType().mainType()).append("/").append(ct.mediaType().subType()).toString()), Headers$.MODULE$.get$extension(response.headers(), Header.Select$.MODULE$.singleHeaders(Content$minusType$.MODULE$.headerInstance())).map((Function1 & Serializable)ct -> new StringBuilder(1).append(ct.mediaType().mainType()).append("/").append(ct.mediaType().subType()).toString()), (Option)BaklavaResponseContext$.MODULE$.$lessinit$greater$default$11());
    }

    public static Request baklavaContextToHttpRequest$(BaklavaHttp4s $this, BaklavaRequestContext ctx, EntityEncoder requestBody) {
        return $this.baklavaContextToHttpRequest(ctx, requestBody);
    }

    default public <RequestBody, PathParameters, PathParametersProvided, QueryParameters, QueryParametersProvided, Headers_, HeadersProvided> Request<IO> baklavaContextToHttpRequest(BaklavaRequestContext<RequestBody, PathParameters, PathParametersProvided, QueryParameters, QueryParametersProvided, Headers_, HeadersProvided> ctx, EntityEncoder<IO, RequestBody> requestBody) {
        Option option = ctx.body();
        if (option instanceof Some) {
            Object body = ((Some)option).value();
            Method method = this.baklavaHttpMethodToHttpMethod((BaklavaHttpMethod)ctx.method().get());
            Uri uri = (Uri)Uri$.MODULE$.fromString(ctx.path()).fold((Function1 & Serializable)_$4 -> {
                throw _$4;
            }, (Function1 & Serializable)x -> (Uri)Predef$.MODULE$.identity(x));
            List list = this.baklavaHeadersToHttpHeaders(ctx.headers());
            HttpVersion httpVersion = Request$.MODULE$.apply$default$3();
            Stream stream = Request$.MODULE$.apply$default$5();
            Vault vault = Request$.MODULE$.apply$default$6();
            return (Request)Request$.MODULE$.apply(method, uri, httpVersion, list, stream, vault).withEntity(body, requestBody);
        }
        if (None$.MODULE$.equals(option)) {
            Method method = this.baklavaHttpMethodToHttpMethod((BaklavaHttpMethod)ctx.method().get());
            Uri uri = (Uri)Uri$.MODULE$.fromString(ctx.path()).fold((Function1 & Serializable)_$5 -> {
                throw _$5;
            }, (Function1 & Serializable)x -> (Uri)Predef$.MODULE$.identity(x));
            List list = this.baklavaHeadersToHttpHeaders(ctx.headers());
            HttpVersion httpVersion = Request$.MODULE$.apply$default$3();
            Stream stream = Request$.MODULE$.apply$default$5();
            Vault vault = Request$.MODULE$.apply$default$6();
            return Request$.MODULE$.apply(method, uri, httpVersion, list, stream, vault);
        }
        throw new MatchError((Object)option);
    }

    public IORuntime runtime();

    private static Status baklavaStatusCodeToStatusCode$$anonfun$1(BaklavaHttpStatus baklavaHttpStatus$1) {
        throw new IllegalStateException(new StringBuilder(21).append("Invalid status code: ").append(baklavaHttpStatus$1.status()).toString());
    }

    private static Method baklavaHttpMethodToHttpMethod$$anonfun$1(BaklavaHttpMethod baklavaHttpMethod$1) {
        throw new IllegalStateException(new StringBuilder(16).append("Invalid method: ").append(baklavaHttpMethod$1.value()).toString());
    }

    private Object httpResponseToBaklavaResponseContext$$anonfun$1(Response newResponse$1, EntityDecoder evidence$1$1) {
        return ((IOPlatform)newResponse$1.as((MonadError)IO$.MODULE$.asyncForIO(), evidence$1$1)).unsafeRunSync(this.runtime());
    }
}

