/*
 * Decompiled with CFR 0.152.
 */
package pl.iterators.stir.server.directives;

import cats.effect.IO;
import cats.effect.IO$;
import java.io.Serializable;
import org.http4s.BasicCredentials$;
import org.http4s.Challenge;
import org.http4s.Challenge$;
import org.http4s.Credentials;
import org.http4s.Header;
import org.http4s.headers.Authorization$;
import org.typelevel.ci.CIString$;
import pl.iterators.stir.server.AuthenticationFailedRejection;
import pl.iterators.stir.server.AuthenticationFailedRejection$;
import pl.iterators.stir.server.AuthenticationFailedRejection$CredentialsMissing$;
import pl.iterators.stir.server.AuthenticationFailedRejection$CredentialsRejected$;
import pl.iterators.stir.server.AuthorizationFailedRejection$;
import pl.iterators.stir.server.Directive;
import pl.iterators.stir.server.Directive$;
import pl.iterators.stir.server.Directive$SingleValueTransformers$;
import pl.iterators.stir.server.Rejection;
import pl.iterators.stir.server.RequestContext;
import pl.iterators.stir.server.StandardRoute$;
import pl.iterators.stir.server.directives.AuthenticationDirective;
import pl.iterators.stir.server.directives.AuthenticationDirective$;
import pl.iterators.stir.server.directives.AuthenticationResult$;
import pl.iterators.stir.server.directives.BasicDirectives$;
import pl.iterators.stir.server.directives.CredentialsHelper;
import pl.iterators.stir.server.directives.CredentialsHelper$;
import pl.iterators.stir.server.directives.HeaderDirectives$;
import pl.iterators.stir.server.directives.IODirectives$;
import pl.iterators.stir.server.directives.OnSuccessMagnet$;
import pl.iterators.stir.server.directives.ParameterDirectives$;
import pl.iterators.stir.server.directives.RouteDirectives$;
import pl.iterators.stir.unmarshalling.Unmarshaller$;
import pl.iterators.stir.util.Tuple$;
import pl.iterators.stir.util.Tupler$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple1;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

public interface SecurityDirectives {
    public static Directive extractCredentials$(SecurityDirectives $this) {
        return $this.extractCredentials();
    }

    default public Directive<Tuple1<Option<Credentials>>> extractCredentials() {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(HeaderDirectives$.MODULE$.optionalHeaderValueByType(Header.Select$.MODULE$.singleHeaders(Authorization$.MODULE$.headerInstance())));
        return Directive$SingleValueTransformers$.MODULE$.map$extension(directive, (Function1 & Serializable)_$1 -> _$1.map((Function1 & Serializable)_$2 -> _$2.credentials()), Tupler$.MODULE$.forAnyRef());
    }

    public static AuthenticationDirective authenticateBasic$(SecurityDirectives $this, String realm, Function1 authenticator) {
        return $this.authenticateBasic(realm, authenticator);
    }

    default public <T> AuthenticationDirective<T> authenticateBasic(String realm, Function1<CredentialsHelper, Option<T>> authenticator) {
        return this.authenticateBasicAsync(realm, (Function1 & Serializable)cred -> IO$.MODULE$.pure(authenticator.apply(cred)));
    }

    public static AuthenticationDirective authenticateBasicAsync$(SecurityDirectives $this, String realm, Function1 authenticator) {
        return $this.authenticateBasicAsync(realm, authenticator);
    }

    default public <T> AuthenticationDirective<T> authenticateBasicAsync(String realm, Function1<CredentialsHelper, IO<Option<T>>> authenticator) {
        return this.authenticateOrRejectWithChallenge((Function1 & Serializable)credAll -> {
            None$ none$;
            Option option;
            Some some;
            Credentials credentials;
            Option option2 = credAll;
            if (option2 instanceof Some && (credentials = (Credentials)(some = (Some)option2).value()) != null && !(option = BasicCredentials$.MODULE$.unapply(credentials)).isEmpty()) {
                Tuple2 tuple2 = (Tuple2)option.get();
                Some b = some;
                none$ = b;
            } else {
                none$ = None$.MODULE$;
            }
            None$ cred = none$;
            return ((IO)authenticator.apply((Object)CredentialsHelper$.MODULE$.apply((Option<Credentials>)cred))).map((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    Object t = ((Some)option).value();
                    return AuthenticationResult$.MODULE$.success(t);
                }
                if (None$.MODULE$.equals(option)) {
                    Object[] objectArray = new Tuple2[1];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"charset");
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"UTF-8");
                    return AuthenticationResult$.MODULE$.failWithChallenge(Challenge$.MODULE$.apply("Basic", realm, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
                }
                throw new MatchError((Object)option);
            });
        }, ClassTag$.MODULE$.apply(Credentials.class));
    }

    public static AuthenticationDirective authenticateBasicPF$(SecurityDirectives $this, String realm, PartialFunction authenticator) {
        return $this.authenticateBasicPF(realm, authenticator);
    }

    default public <T> AuthenticationDirective<T> authenticateBasicPF(String realm, PartialFunction<CredentialsHelper, T> authenticator) {
        return this.authenticateBasic(realm, authenticator.lift());
    }

    public static AuthenticationDirective authenticateBasicPFAsync$(SecurityDirectives $this, String realm, PartialFunction authenticator) {
        return $this.authenticateBasicPFAsync(realm, authenticator);
    }

    default public <T> AuthenticationDirective<T> authenticateBasicPFAsync(String realm, PartialFunction<CredentialsHelper, IO<T>> authenticator) {
        return this.authenticateBasicAsync(realm, (Function1 & Serializable)credentials -> {
            if (authenticator.isDefinedAt(credentials)) {
                return ((IO)authenticator.apply(credentials)).map((Function1 & Serializable)_$3 -> Some$.MODULE$.apply(_$3));
            }
            return IO$.MODULE$.pure((Object)None$.MODULE$);
        });
    }

    public static AuthenticationDirective authenticateOAuth2$(SecurityDirectives $this, String realm, Function1 authenticator) {
        return $this.authenticateOAuth2(realm, authenticator);
    }

    default public <T> AuthenticationDirective<T> authenticateOAuth2(String realm, Function1<CredentialsHelper, Option<T>> authenticator) {
        return this.authenticateOAuth2Async(realm, (Function1 & Serializable)cred -> IO$.MODULE$.pure(authenticator.apply(cred)));
    }

    public static AuthenticationDirective authenticateOAuth2Async$(SecurityDirectives $this, String realm, Function1 authenticator) {
        return $this.authenticateOAuth2Async(realm, authenticator);
    }

    default public <T> AuthenticationDirective<T> authenticateOAuth2Async(String realm, Function1<CredentialsHelper, IO<Option<T>>> authenticator) {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(this.extractCredentials());
        Directive extractCreds = Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1 & Serializable)x$1 -> {
            Credentials credentials;
            Option option = x$1;
            if (option instanceof Some && (credentials = (Credentials)((Some)option).value()) instanceof Credentials.Token) {
                Credentials.Token c = (Credentials.Token)credentials;
                return BasicDirectives$.MODULE$.provide(Some$.MODULE$.apply((Object)c));
            }
            return SecurityDirectives.extractAccessTokenParameterAsBearerToken$1();
        }, Tuple$.MODULE$.forTuple1());
        return this.extractCredentialsAndAuthenticateOrRejectWithChallenge(extractCreds, (Function1 & Serializable)cred -> ((IO)authenticator.apply((Object)CredentialsHelper$.MODULE$.apply((Option<Credentials>)cred))).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Object t = ((Some)option).value();
                return AuthenticationResult$.MODULE$.success(t);
            }
            if (None$.MODULE$.equals(option)) {
                return AuthenticationResult$.MODULE$.failWithChallenge(Challenge$.MODULE$.apply("Bearer", realm, Challenge$.MODULE$.$lessinit$greater$default$3()));
            }
            throw new MatchError((Object)option);
        }));
    }

    public static AuthenticationDirective authenticateOAuth2PF$(SecurityDirectives $this, String realm, PartialFunction authenticator) {
        return $this.authenticateOAuth2PF(realm, authenticator);
    }

    default public <T> AuthenticationDirective<T> authenticateOAuth2PF(String realm, PartialFunction<CredentialsHelper, T> authenticator) {
        return this.authenticateOAuth2(realm, authenticator.lift());
    }

    public static AuthenticationDirective authenticateOAuth2PFAsync$(SecurityDirectives $this, String realm, PartialFunction authenticator) {
        return $this.authenticateOAuth2PFAsync(realm, authenticator);
    }

    default public <T> AuthenticationDirective<T> authenticateOAuth2PFAsync(String realm, PartialFunction<CredentialsHelper, IO<T>> authenticator) {
        return this.authenticateOAuth2Async(realm, (Function1 & Serializable)credentials -> {
            if (authenticator.isDefinedAt(credentials)) {
                return ((IO)authenticator.apply(credentials)).map((Function1 & Serializable)_$5 -> Some$.MODULE$.apply(_$5));
            }
            return IO$.MODULE$.pure((Object)None$.MODULE$);
        });
    }

    private <C extends Credentials, T> AuthenticationDirective<T> extractCredentialsAndAuthenticateOrRejectWithChallenge(Directive<Tuple1<Option<C>>> extractCredentials, Function1<Option<C>, IO<Either<Challenge, T>>> authenticator) {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(extractCredentials);
        return AuthenticationDirective$.MODULE$.apply(Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1 & Serializable)cred -> {
            Directive directive = Directive$.MODULE$.SingleValueTransformers(IODirectives$.MODULE$.onSuccess(OnSuccessMagnet$.MODULE$.apply(() -> SecurityDirectives.extractCredentialsAndAuthenticateOrRejectWithChallenge$$anonfun$1$$anonfun$1(authenticator, cred), Tupler$.MODULE$.forAnyRef())));
            return Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Right) {
                    Object user = ((Right)either).value();
                    return BasicDirectives$.MODULE$.provide(user);
                }
                if (either instanceof Left) {
                    Challenge challenge = (Challenge)((Left)either).value();
                    AuthenticationFailedRejection.Cause cause = (AuthenticationFailedRejection.Cause)(cred.isEmpty() ? AuthenticationFailedRejection$CredentialsMissing$.MODULE$ : AuthenticationFailedRejection$CredentialsRejected$.MODULE$);
                    return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{AuthenticationFailedRejection$.MODULE$.apply(cause, challenge)})), Tuple$.MODULE$.forTuple1());
                }
                throw new MatchError((Object)either);
            }, Tuple$.MODULE$.forTuple1());
        }, Tuple$.MODULE$.forTuple1()));
    }

    public static AuthenticationDirective authenticateOrRejectWithChallenge$(SecurityDirectives $this, Function1 authenticator) {
        return $this.authenticateOrRejectWithChallenge(authenticator);
    }

    default public <T> AuthenticationDirective<T> authenticateOrRejectWithChallenge(Function1<Option<Credentials>, IO<Either<Challenge, T>>> authenticator) {
        return this.extractCredentialsAndAuthenticateOrRejectWithChallenge(this.extractCredentials(), authenticator);
    }

    public static AuthenticationDirective authenticateOrRejectWithChallenge$(SecurityDirectives $this, Function1 authenticator, ClassTag evidence$1) {
        return $this.authenticateOrRejectWithChallenge(authenticator, evidence$1);
    }

    default public <C extends Credentials, T> AuthenticationDirective<T> authenticateOrRejectWithChallenge(Function1<Option<C>, IO<Either<Challenge, T>>> authenticator, ClassTag<C> evidence$1) {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(this.extractCredentials());
        return this.extractCredentialsAndAuthenticateOrRejectWithChallenge(Directive$SingleValueTransformers$.MODULE$.map$extension(directive, (Function1 & Serializable)_$6 -> _$6.collect((PartialFunction)new Serializable(evidence$1){
            private final ClassTag evidence$1$2;
            {
                this.evidence$1$2 = evidence$1$3;
            }

            public final boolean isDefinedAt(Credentials x) {
                Option option;
                Credentials credentials = x;
                if (credentials != null && !(option = this.evidence$1$2.unapply((Object)credentials)).isEmpty()) {
                    Credentials credentials2;
                    Credentials c = credentials2 = (Credentials)option.get();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Credentials x, Function1 function1) {
                Option option;
                Credentials credentials = x;
                if (credentials != null && !(option = this.evidence$1$2.unapply((Object)credentials)).isEmpty()) {
                    Credentials credentials2;
                    Credentials c = credentials2 = (Credentials)option.get();
                    return c;
                }
                return function1.apply((Object)x);
            }
        }), Tupler$.MODULE$.forAnyRef()), authenticator);
    }

    public static Directive authorize$(SecurityDirectives $this, Function0 check) {
        return $this.authorize((Function0<Object>)check);
    }

    default public Directive<BoxedUnit> authorize(Function0<Object> check) {
        return this.authorize((Function1<RequestContext, Object>)(Function1 & Serializable)_$7 -> check.apply$mcZ$sp());
    }

    public static Directive authorize$(SecurityDirectives $this, Function1 check) {
        return $this.authorize((Function1<RequestContext, Object>)check);
    }

    default public Directive<BoxedUnit> authorize(Function1<RequestContext, Object> check) {
        return this.authorizeAsync((Function1<RequestContext, IO<Object>>)(Function1 & Serializable)ctx -> IO$.MODULE$.pure(check.apply(ctx)));
    }

    public static Directive authorizeAsync$(SecurityDirectives $this, Function0 check) {
        return $this.authorizeAsync((Function0<IO<Object>>)check);
    }

    default public Directive<BoxedUnit> authorizeAsync(Function0<IO<Object>> check) {
        return this.authorizeAsync((Function1<RequestContext, IO<Object>>)(Function1 & Serializable)_$8 -> (IO)check.apply());
    }

    public static Directive authorizeAsync$(SecurityDirectives $this, Function1 check) {
        return $this.authorizeAsync((Function1<RequestContext, IO<Object>>)check);
    }

    default public Directive<BoxedUnit> authorizeAsync(Function1<RequestContext, IO<Object>> check) {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(BasicDirectives$.MODULE$.extract((Function1)check));
        return Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1 & Serializable)fa -> {
            Directive directive = Directive$.MODULE$.SingleValueTransformers(IODirectives$.MODULE$.onComplete(() -> SecurityDirectives.authorizeAsync$$anonfun$2$$anonfun$1(fa)));
            return Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1 & Serializable)x$1 -> {
                Try try_ = x$1;
                if (try_ instanceof Success && BoxesRunTime.unboxToBoolean((Object)((Success)try_).value())) {
                    return BasicDirectives$.MODULE$.pass();
                }
                return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{AuthorizationFailedRejection$.MODULE$})), Tuple$.MODULE$.forUnit());
            }, Tuple$.MODULE$.forUnit());
        }, Tuple$.MODULE$.forUnit());
    }

    private static Directive extractAccessTokenParameterAsBearerToken$1() {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(ParameterDirectives$.MODULE$.parameter(ParameterDirectives$.MODULE$.ParamSpec().forNOR(ParameterDirectives$.MODULE$._string2NR("access_token").optional(), Unmarshaller$.MODULE$.sourceOptionUnmarshaller(Unmarshaller$.MODULE$.identityUnmarshaller()))));
        return Directive$SingleValueTransformers$.MODULE$.map$extension(directive, (Function1 & Serializable)_$4 -> _$4.map((Function1 & Serializable)t -> Credentials.Token$.MODULE$.apply(CIString$.MODULE$.apply("Bearer"), t)), Tupler$.MODULE$.forAnyRef());
    }

    private static IO extractCredentialsAndAuthenticateOrRejectWithChallenge$$anonfun$1$$anonfun$1(Function1 authenticator$8, Option cred$1) {
        return (IO)authenticator$8.apply((Object)cred$1);
    }

    private static IO authorizeAsync$$anonfun$2$$anonfun$1(IO fa$1) {
        return fa$1;
    }
}

