/*
 * Decompiled with CFR 0.152.
 */
package pl.iterators.stir.unmarshalling;

import cats.UnorderedFoldable$;
import cats.effect.IO;
import cats.effect.IO$;
import cats.implicits$;
import cats.syntax.ParallelSequenceOps1$;
import java.io.Serializable;
import java.util.UUID;
import java.util.regex.Pattern;
import pl.iterators.stir.unmarshalling.Unmarshaller;
import pl.iterators.stir.unmarshalling.Unmarshaller$;
import pl.iterators.stir.unmarshalling.Unmarshaller$NoContentException$;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.Nothing$;

public interface PredefinedFromStringUnmarshallers {
    public static void $init$(PredefinedFromStringUnmarshallers $this) {
        $this.pl$iterators$stir$unmarshalling$PredefinedFromStringUnmarshallers$_setter_$byteFromStringUnmarshaller_$eq($this.numberUnmarshaller((Function1 & Serializable)_$1 -> StringOps$.MODULE$.toByte$extension(Predef$.MODULE$.augmentString(_$1)), "8-bit signed integer"));
        $this.pl$iterators$stir$unmarshalling$PredefinedFromStringUnmarshallers$_setter_$shortFromStringUnmarshaller_$eq($this.numberUnmarshaller((Function1 & Serializable)_$2 -> StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(_$2)), "16-bit signed integer"));
        $this.pl$iterators$stir$unmarshalling$PredefinedFromStringUnmarshallers$_setter_$intFromStringUnmarshaller_$eq($this.numberUnmarshaller((Function1 & Serializable)_$3 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$3)), "32-bit signed integer"));
        $this.pl$iterators$stir$unmarshalling$PredefinedFromStringUnmarshallers$_setter_$longFromStringUnmarshaller_$eq($this.numberUnmarshaller((Function1 & Serializable)_$4 -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(_$4)), "64-bit signed integer"));
        $this.pl$iterators$stir$unmarshalling$PredefinedFromStringUnmarshallers$_setter_$floatFromStringUnmarshaller_$eq($this.numberUnmarshaller((Function1 & Serializable)_$5 -> StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(_$5)), "32-bit floating point"));
        $this.pl$iterators$stir$unmarshalling$PredefinedFromStringUnmarshallers$_setter_$doubleFromStringUnmarshaller_$eq($this.numberUnmarshaller((Function1 & Serializable)_$6 -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(_$6)), "64-bit floating point"));
        $this.pl$iterators$stir$unmarshalling$PredefinedFromStringUnmarshallers$_setter_$booleanFromStringUnmarshaller_$eq(Unmarshaller$.MODULE$.strict((Function1 & Serializable)string -> {
            String string2 = string.toLowerCase();
            switch (string2 == null ? 0 : string2.hashCode()) {
                case 0: {
                    if (!"".equals(string2)) break;
                    throw Unmarshaller$NoContentException$.MODULE$;
                }
                case 48: {
                    if ("0".equals(string2)) return false;
                    break;
                }
                case 49: {
                    if ("1".equals(string2)) return true;
                    break;
                }
                case 3521: {
                    if ("no".equals(string2)) return false;
                    break;
                }
                case 3551: {
                    if ("on".equals(string2)) return true;
                    break;
                }
                case 109935: {
                    if ("off".equals(string2)) return false;
                    break;
                }
                case 119527: {
                    if ("yes".equals(string2)) return true;
                    break;
                }
                case 3569038: {
                    if ("true".equals(string2)) return true;
                    break;
                }
                case 97196323: {
                    if ("false".equals(string2)) return false;
                    break;
                }
            }
            String x = string2;
            throw new IllegalArgumentException(new StringBuilder(31).append("'").append(x).append("' is not a valid Boolean value").toString());
        }));
        Pattern validUuidPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}")).pattern();
        $this.pl$iterators$stir$unmarshalling$PredefinedFromStringUnmarshallers$_setter_$uuidFromStringUnmarshaller_$eq(Unmarshaller$.MODULE$.strict((Function1 & Serializable)string -> {
            if (validUuidPattern.matcher((CharSequence)string).matches()) {
                return UUID.fromString(string);
            }
            throw new IllegalArgumentException(new StringBuilder(28).append("'").append((String)string).append("' is not a valid UUID value").toString());
        }));
        $this.pl$iterators$stir$unmarshalling$PredefinedFromStringUnmarshallers$_setter_$HexByte_$eq($this.numberUnmarshaller((Function1 & Serializable)_$8 -> Byte.parseByte(_$8, 16), "8-bit hexadecimal integer"));
        $this.pl$iterators$stir$unmarshalling$PredefinedFromStringUnmarshallers$_setter_$HexShort_$eq($this.numberUnmarshaller((Function1 & Serializable)_$9 -> Short.parseShort(_$9, 16), "16-bit hexadecimal integer"));
        $this.pl$iterators$stir$unmarshalling$PredefinedFromStringUnmarshallers$_setter_$HexInt_$eq($this.numberUnmarshaller((Function1 & Serializable)_$10 -> Integer.parseInt(_$10, 16), "32-bit hexadecimal integer"));
        $this.pl$iterators$stir$unmarshalling$PredefinedFromStringUnmarshallers$_setter_$HexLong_$eq($this.numberUnmarshaller((Function1 & Serializable)_$11 -> Long.parseLong(_$11, 16), "64-bit hexadecimal integer"));
    }

    public Unmarshaller<String, Object> byteFromStringUnmarshaller();

    public void pl$iterators$stir$unmarshalling$PredefinedFromStringUnmarshallers$_setter_$byteFromStringUnmarshaller_$eq(Unmarshaller var1);

    public Unmarshaller<String, Object> shortFromStringUnmarshaller();

    public void pl$iterators$stir$unmarshalling$PredefinedFromStringUnmarshallers$_setter_$shortFromStringUnmarshaller_$eq(Unmarshaller var1);

    public Unmarshaller<String, Object> intFromStringUnmarshaller();

    public void pl$iterators$stir$unmarshalling$PredefinedFromStringUnmarshallers$_setter_$intFromStringUnmarshaller_$eq(Unmarshaller var1);

    public Unmarshaller<String, Object> longFromStringUnmarshaller();

    public void pl$iterators$stir$unmarshalling$PredefinedFromStringUnmarshallers$_setter_$longFromStringUnmarshaller_$eq(Unmarshaller var1);

    public Unmarshaller<String, Object> floatFromStringUnmarshaller();

    public void pl$iterators$stir$unmarshalling$PredefinedFromStringUnmarshallers$_setter_$floatFromStringUnmarshaller_$eq(Unmarshaller var1);

    public Unmarshaller<String, Object> doubleFromStringUnmarshaller();

    public void pl$iterators$stir$unmarshalling$PredefinedFromStringUnmarshallers$_setter_$doubleFromStringUnmarshaller_$eq(Unmarshaller var1);

    public Unmarshaller<String, Object> booleanFromStringUnmarshaller();

    public void pl$iterators$stir$unmarshalling$PredefinedFromStringUnmarshallers$_setter_$booleanFromStringUnmarshaller_$eq(Unmarshaller var1);

    public Unmarshaller<String, UUID> uuidFromStringUnmarshaller();

    public void pl$iterators$stir$unmarshalling$PredefinedFromStringUnmarshallers$_setter_$uuidFromStringUnmarshaller_$eq(Unmarshaller var1);

    public static Unmarshaller CsvSeq$(PredefinedFromStringUnmarshallers $this, Unmarshaller unmarshaller) {
        return $this.CsvSeq(unmarshaller);
    }

    default public <T> Unmarshaller<String, Seq<T>> CsvSeq(Unmarshaller<String, T> unmarshaller) {
        return Unmarshaller$.MODULE$.strict((Function1 & Serializable)string -> Predef$.MODULE$.wrapRefArray((Object[])string.split(",", -1)).toList()).flatMap((Function1 & Serializable)strings -> {
            Seq seq = (Seq)implicits$.MODULE$.catsSyntaxParallelSequence1(strings.map((Function1 & Serializable)_$7 -> unmarshaller.apply((String)_$7)), UnorderedFoldable$.MODULE$.catsTraverseForSeq());
            return (IO)ParallelSequenceOps1$.MODULE$.parSequence$extension((Object)seq, UnorderedFoldable$.MODULE$.catsTraverseForSeq(), IO$.MODULE$.parallelForIO());
        });
    }

    public Unmarshaller<String, Object> HexByte();

    public void pl$iterators$stir$unmarshalling$PredefinedFromStringUnmarshallers$_setter_$HexByte_$eq(Unmarshaller var1);

    public Unmarshaller<String, Object> HexShort();

    public void pl$iterators$stir$unmarshalling$PredefinedFromStringUnmarshallers$_setter_$HexShort_$eq(Unmarshaller var1);

    public Unmarshaller<String, Object> HexInt();

    public void pl$iterators$stir$unmarshalling$PredefinedFromStringUnmarshallers$_setter_$HexInt_$eq(Unmarshaller var1);

    public Unmarshaller<String, Object> HexLong();

    public void pl$iterators$stir$unmarshalling$PredefinedFromStringUnmarshallers$_setter_$HexLong_$eq(Unmarshaller var1);

    private <T> Unmarshaller<String, T> numberUnmarshaller(Function1<String, T> f, String target) {
        return Unmarshaller$.MODULE$.strict((Function1 & Serializable)string -> {
            Object object;
            try {
                object = f.apply(string);
            }
            catch (Throwable ex$) {
                PartialFunction<Throwable, Nothing$> $1$ = this.numberFormatError((String)string, target);
                if ($1$.isDefinedAt((Object)ex$)) {
                    object = $1$.apply((Object)ex$);
                }
                throw ex$;
            }
            return object;
        });
    }

    private PartialFunction<Throwable, Nothing$> numberFormatError(String value, String target) {
        return new Serializable(value, target){
            private final String value$1;
            private final String target$2;
            {
                this.value$1 = value$2;
                this.target$2 = target$3;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof NumberFormatException) {
                    NumberFormatException e = (NumberFormatException)throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof NumberFormatException) {
                    NumberFormatException e = (NumberFormatException)throwable;
                    if (this.value$1.isEmpty()) {
                        throw Unmarshaller$NoContentException$.MODULE$;
                    }
                    throw new IllegalArgumentException(new StringBuilder(24).append("'").append(this.value$1).append("' is not a valid ").append(this.target$2).append(" value").toString(), e);
                }
                return function1.apply((Object)x);
            }
        };
    }
}

