/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.agile;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import pl.kaszaq.howfastyouaregoing.agile.Issue;

public class AgileProject {
    private final Map<String, Issue> data;
    private final String id;

    AgileProject(String id, Map<String, Issue> data) {
        this.id = id;
        this.data = new HashMap<String, Issue>(data);
    }

    public Collection<Issue> getAllIssues() {
        return new HashMap<String, Issue>(this.data).values();
    }

    public Issue getIssue(String issueId) {
        return this.data.get(issueId);
    }

    public boolean contains(Issue issue) {
        return this.data.containsKey(issue.getKey());
    }

    public boolean contains(String issueKey) {
        return this.data.containsKey(issueKey);
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AgileProject other = (AgileProject)obj;
        return Objects.equals(this.id, other.id);
    }
}

