/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.agile;

import java.util.HashMap;
import java.util.TreeSet;
import pl.kaszaq.howfastyouaregoing.agile.AgileProject;
import pl.kaszaq.howfastyouaregoing.agile.Issue;
import pl.kaszaq.howfastyouaregoing.agile.IssueData;
import pl.kaszaq.howfastyouaregoing.agile.IssueStatusMapping;
import pl.kaszaq.howfastyouaregoing.agile.IssueStatusTransition;
import pl.kaszaq.howfastyouaregoing.agile.pojo.AgileProjectData;

public class AgileProjectFactory {
    public AgileProject createAgileProject(AgileProjectData projectData, IssueStatusMapping statusMapping) {
        HashMap<String, Issue> transformedAgileProjectData = new HashMap<String, Issue>();
        projectData.getIssues().entrySet().forEach(entry -> {
            String k = (String)entry.getKey();
            IssueData v = (IssueData)entry.getValue();
            Issue issue = new Issue(IssueData.builder().created(v.getCreated()).creator(v.getCreator()).summary(v.getSummary()).description(v.getDescription()).issueStatusTransitions(this.remapStatusTransitions(v, statusMapping)).issueBlockedTransitions(v.getIssueBlockedTransitions()).key(v.getKey()).linkedIssuesKeys(v.getLinkedIssuesKeys()).parentIssueKey(v.getParentIssueKey()).resolution(v.getResolution()).subtask(v.isSubtask()).subtaskKeys(v.getSubtaskKeys()).status(v.getStatus()).updated(v.getUpdated()).type(v.getType()).labels(v.getLabels()).components(v.getComponents()).customFields(v.getCustomFields()).build());
            transformedAgileProjectData.put(k, issue);
        });
        return new AgileProject(projectData.getProjectId(), transformedAgileProjectData);
    }

    private TreeSet<IssueStatusTransition> remapStatusTransitions(IssueData v, IssueStatusMapping statusMapping) {
        if (statusMapping == null) {
            return v.getIssueStatusTransitions();
        }
        TreeSet<IssueStatusTransition> newStatusTransitionSet = new TreeSet<IssueStatusTransition>();
        for (IssueStatusTransition issueStatusTransition : v.getIssueStatusTransitions()) {
            IssueStatusTransition newStatusTransition = new IssueStatusTransition(issueStatusTransition.getUser(), issueStatusTransition.getDate(), statusMapping.mapStatus(issueStatusTransition.getFromStatus()), statusMapping.mapStatus(issueStatusTransition.getToStatus()));
            newStatusTransitionSet.add(newStatusTransition);
        }
        return newStatusTransitionSet;
    }
}

