/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.agile;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import pl.kaszaq.howfastyouaregoing.agile.IssueBlockedTransition;
import pl.kaszaq.howfastyouaregoing.agile.IssueStatusTransition;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IssueData {
    private final String key;
    private final String creator;
    private final String type;
    private final String resolution;
    private final String status;
    private final String summary;
    private final String description;
    private final ZonedDateTime created;
    private final ZonedDateTime updated;
    private final boolean subtask;
    private final String parentIssueKey;
    private final List<String> subtaskKeys;
    private final List<String> linkedIssuesKeys;
    private final List<String> labels;
    private final List<String> components;
    private final TreeSet<IssueStatusTransition> issueStatusTransitions;
    private final TreeSet<IssueBlockedTransition> issueBlockedTransitions;
    private final Map<String, Object> customFields;

    @JsonIgnore
    public String getPrettyName() {
        return "[" + this.getKey() + "] " + this.getSummary();
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Objects.hashCode(this.key);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IssueData other = (IssueData)obj;
        return Objects.equals(this.key, other.key);
    }

    IssueData(String key, String creator, String type, String resolution, String status, String summary, String description, ZonedDateTime created, ZonedDateTime updated, boolean subtask, String parentIssueKey, List<String> subtaskKeys, List<String> linkedIssuesKeys, List<String> labels, List<String> components, TreeSet<IssueStatusTransition> issueStatusTransitions, TreeSet<IssueBlockedTransition> issueBlockedTransitions, Map<String, Object> customFields) {
        this.key = key;
        this.creator = creator;
        this.type = type;
        this.resolution = resolution;
        this.status = status;
        this.summary = summary;
        this.description = description;
        this.created = created;
        this.updated = updated;
        this.subtask = subtask;
        this.parentIssueKey = parentIssueKey;
        this.subtaskKeys = subtaskKeys;
        this.linkedIssuesKeys = linkedIssuesKeys;
        this.labels = labels;
        this.components = components;
        this.issueStatusTransitions = issueStatusTransitions;
        this.issueBlockedTransitions = issueBlockedTransitions;
        this.customFields = customFields;
    }

    public static IssueDataBuilder builder() {
        return new IssueDataBuilder();
    }

    public String getKey() {
        return this.key;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getType() {
        return this.type;
    }

    public String getResolution() {
        return this.resolution;
    }

    public String getStatus() {
        return this.status;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public ZonedDateTime getCreated() {
        return this.created;
    }

    public ZonedDateTime getUpdated() {
        return this.updated;
    }

    public boolean isSubtask() {
        return this.subtask;
    }

    public String getParentIssueKey() {
        return this.parentIssueKey;
    }

    public List<String> getSubtaskKeys() {
        return this.subtaskKeys;
    }

    public List<String> getLinkedIssuesKeys() {
        return this.linkedIssuesKeys;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public List<String> getComponents() {
        return this.components;
    }

    public TreeSet<IssueStatusTransition> getIssueStatusTransitions() {
        return this.issueStatusTransitions;
    }

    public TreeSet<IssueBlockedTransition> getIssueBlockedTransitions() {
        return this.issueBlockedTransitions;
    }

    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public String toString() {
        return "IssueData(key=" + this.getKey() + ", creator=" + this.getCreator() + ", type=" + this.getType() + ", resolution=" + this.getResolution() + ", status=" + this.getStatus() + ", summary=" + this.getSummary() + ", description=" + this.getDescription() + ", created=" + this.getCreated() + ", updated=" + this.getUpdated() + ", subtask=" + this.isSubtask() + ", parentIssueKey=" + this.getParentIssueKey() + ", subtaskKeys=" + this.getSubtaskKeys() + ", linkedIssuesKeys=" + this.getLinkedIssuesKeys() + ", labels=" + this.getLabels() + ", components=" + this.getComponents() + ", issueStatusTransitions=" + this.getIssueStatusTransitions() + ", issueBlockedTransitions=" + this.getIssueBlockedTransitions() + ", customFields=" + this.getCustomFields() + ")";
    }

    public static class IssueDataBuilder {
        private String key;
        private String creator;
        private String type;
        private String resolution;
        private String status;
        private String summary;
        private String description;
        private ZonedDateTime created;
        private ZonedDateTime updated;
        private boolean subtask;
        private String parentIssueKey;
        private List<String> subtaskKeys;
        private List<String> linkedIssuesKeys;
        private List<String> labels;
        private List<String> components;
        private TreeSet<IssueStatusTransition> issueStatusTransitions;
        private TreeSet<IssueBlockedTransition> issueBlockedTransitions;
        private Map<String, Object> customFields;

        IssueDataBuilder() {
        }

        public IssueDataBuilder key(String key) {
            this.key = key;
            return this;
        }

        public IssueDataBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public IssueDataBuilder type(String type) {
            this.type = type;
            return this;
        }

        public IssueDataBuilder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        public IssueDataBuilder status(String status) {
            this.status = status;
            return this;
        }

        public IssueDataBuilder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public IssueDataBuilder description(String description) {
            this.description = description;
            return this;
        }

        public IssueDataBuilder created(ZonedDateTime created) {
            this.created = created;
            return this;
        }

        public IssueDataBuilder updated(ZonedDateTime updated) {
            this.updated = updated;
            return this;
        }

        public IssueDataBuilder subtask(boolean subtask) {
            this.subtask = subtask;
            return this;
        }

        public IssueDataBuilder parentIssueKey(String parentIssueKey) {
            this.parentIssueKey = parentIssueKey;
            return this;
        }

        public IssueDataBuilder subtaskKeys(List<String> subtaskKeys) {
            this.subtaskKeys = subtaskKeys;
            return this;
        }

        public IssueDataBuilder linkedIssuesKeys(List<String> linkedIssuesKeys) {
            this.linkedIssuesKeys = linkedIssuesKeys;
            return this;
        }

        public IssueDataBuilder labels(List<String> labels) {
            this.labels = labels;
            return this;
        }

        public IssueDataBuilder components(List<String> components) {
            this.components = components;
            return this;
        }

        public IssueDataBuilder issueStatusTransitions(TreeSet<IssueStatusTransition> issueStatusTransitions) {
            this.issueStatusTransitions = issueStatusTransitions;
            return this;
        }

        public IssueDataBuilder issueBlockedTransitions(TreeSet<IssueBlockedTransition> issueBlockedTransitions) {
            this.issueBlockedTransitions = issueBlockedTransitions;
            return this;
        }

        public IssueDataBuilder customFields(Map<String, Object> customFields) {
            this.customFields = customFields;
            return this;
        }

        public IssueData build() {
            return new IssueData(this.key, this.creator, this.type, this.resolution, this.status, this.summary, this.description, this.created, this.updated, this.subtask, this.parentIssueKey, this.subtaskKeys, this.linkedIssuesKeys, this.labels, this.components, this.issueStatusTransitions, this.issueBlockedTransitions, this.customFields);
        }

        public String toString() {
            return "IssueData.IssueDataBuilder(key=" + this.key + ", creator=" + this.creator + ", type=" + this.type + ", resolution=" + this.resolution + ", status=" + this.status + ", summary=" + this.summary + ", description=" + this.description + ", created=" + this.created + ", updated=" + this.updated + ", subtask=" + this.subtask + ", parentIssueKey=" + this.parentIssueKey + ", subtaskKeys=" + this.subtaskKeys + ", linkedIssuesKeys=" + this.linkedIssuesKeys + ", labels=" + this.labels + ", components=" + this.components + ", issueStatusTransitions=" + this.issueStatusTransitions + ", issueBlockedTransitions=" + this.issueBlockedTransitions + ", customFields=" + this.customFields + ")";
        }
    }
}

