/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.agile;

import com.google.common.collect.ImmutableSet;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import pl.kaszaq.howfastyouaregoing.agile.Issue;
import pl.kaszaq.howfastyouaregoing.agile.IssueStatusTransition;
import pl.kaszaq.howfastyouaregoing.utils.CommonPredicates;

public class IssuePredicates {
    public static Predicate<Issue> updatedAfter(ZonedDateTime date) {
        return issue -> issue.getUpdated().isAfter(date);
    }

    public static Predicate<Issue> createdAfter(ZonedDateTime date) {
        return issue -> issue.getCreated().isAfter(date);
    }

    public static Predicate<Issue> hasStatusTransitionsThat(Predicate<IssueStatusTransition> ... predicates) {
        Optional<Predicate<IssueStatusTransition>> predicate = Arrays.stream(predicates).reduce((p1, p2) -> p1.and(p2));
        return issue -> issue.getIssueStatusTransitions().stream().anyMatch(predicate.orElse(CommonPredicates.alwaysTrue()));
    }

    public static Predicate<Issue> hasSubtasks() {
        return issue -> !issue.getSubtaskKeys().isEmpty();
    }

    public static Predicate<Issue> isSubtask() {
        return issue -> issue.isSubtask();
    }

    public static Predicate<Issue> isEpic() {
        return issue -> issue.getType().equals("Epic");
    }

    public static Predicate<Issue> inResolution(String ... resolutions) {
        ImmutableSet allowedStatuses = ImmutableSet.copyOf((Object[])resolutions);
        return arg_0 -> IssuePredicates.lambda$inResolution$7((Set)allowedStatuses, arg_0);
    }

    public static Predicate<Issue> inStatus(String ... statusNames) {
        ImmutableSet allowedStatuses = ImmutableSet.copyOf((Object[])statusNames);
        return arg_0 -> IssuePredicates.lambda$inStatus$8((Set)allowedStatuses, arg_0);
    }

    public static Predicate<Issue> hasComponents(String ... components) {
        ImmutableSet requiredComponents = ImmutableSet.copyOf((Object[])components);
        return arg_0 -> IssuePredicates.lambda$hasComponents$9((Set)requiredComponents, arg_0);
    }

    public static Predicate<Issue> hasLabels(String ... labels) {
        ImmutableSet requiredLabels = ImmutableSet.copyOf((Object[])labels);
        return arg_0 -> IssuePredicates.lambda$hasLabels$10((Set)requiredLabels, arg_0);
    }

    public static Predicate<Issue> inStatusOnDay(LocalDate date, String ... statusNames) {
        ImmutableSet allowedStatuses = ImmutableSet.copyOf((Object[])statusNames);
        return arg_0 -> IssuePredicates.lambda$inStatusOnDay$11(date, (Set)allowedStatuses, arg_0);
    }

    public static Predicate<Issue> isBlockedEntireDay(LocalDate date) {
        return issue -> issue.getAllDayBlockedDays().contains(date);
    }

    private static /* synthetic */ boolean lambda$inStatusOnDay$11(LocalDate date, Set allowedStatuses, Issue issue) {
        return issue.isStatusOnDay(date, allowedStatuses);
    }

    private static /* synthetic */ boolean lambda$hasLabels$10(Set requiredLabels, Issue issue) {
        return issue.getLabels().containsAll(requiredLabels);
    }

    private static /* synthetic */ boolean lambda$hasComponents$9(Set requiredComponents, Issue issue) {
        return issue.getComponents().containsAll(requiredComponents);
    }

    private static /* synthetic */ boolean lambda$inStatus$8(Set allowedStatuses, Issue issue) {
        return allowedStatuses.contains(issue.getStatus());
    }

    private static /* synthetic */ boolean lambda$inResolution$7(Set allowedStatuses, Issue issue) {
        return issue.getResolution() != null && allowedStatuses.contains(issue.getResolution());
    }
}

