/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.agile.jira;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.kaszaq.howfastyouaregoing.Config;
import pl.kaszaq.howfastyouaregoing.agile.AgileProject;
import pl.kaszaq.howfastyouaregoing.agile.AgileProjectConfiguration;
import pl.kaszaq.howfastyouaregoing.agile.AgileProjectFactory;
import pl.kaszaq.howfastyouaregoing.agile.AgileProjectProvider;
import pl.kaszaq.howfastyouaregoing.agile.IssueData;
import pl.kaszaq.howfastyouaregoing.agile.jira.JiraIssueParser;
import pl.kaszaq.howfastyouaregoing.agile.jira.JiraSearchRequest;
import pl.kaszaq.howfastyouaregoing.agile.pojo.AgileProjectData;
import pl.kaszaq.howfastyouaregoing.http.HttpClient;
import pl.kaszaq.howfastyouaregoing.json.JsonNodeOptional;

public class JiraAgileProjectProvider
implements AgileProjectProvider {
    private static final Logger LOG = LoggerFactory.getLogger(JiraAgileProjectProvider.class);
    private static final ZonedDateTime INITIAL_DATE = ZonedDateTime.of(1970, Month.JANUARY.getValue(), 1, 0, 0, 0, 0, ZoneId.systemDefault());
    public static final int MINUTES_UNTIL_UPDATE_REQUESTED = 15;
    private final JiraIssueParser issueParser;
    private final HttpClient httpClient;
    private final File jiraCacheDirectory;
    private final File jiraCacheIssuesDirectory;
    private final String jiraSearchEndpoint;
    private final Set<String> customFieldsNames;

    JiraAgileProjectProvider(HttpClient client, File jiraCacheDirectory, File jiraCacheIssuesDirectory, String jiraSearchEndpoint, Map<String, Function<JsonNodeOptional, Object>> customFieldsParsers) {
        this.jiraCacheDirectory = jiraCacheDirectory;
        this.jiraCacheIssuesDirectory = jiraCacheIssuesDirectory;
        this.jiraSearchEndpoint = jiraSearchEndpoint;
        this.httpClient = client;
        this.issueParser = new JiraIssueParser(customFieldsParsers);
        this.customFieldsNames = new HashSet<String>(customFieldsParsers.keySet());
    }

    @Override
    public Optional<AgileProject> loadProject(String projectId, AgileProjectConfiguration configuration) {
        try {
            Optional<AgileProjectData> projectDataOptional = this.loadProjectFromFile(projectId);
            AgileProjectData projectData = projectDataOptional.orElse(this.createNewEmptyProject(projectId));
            if (!this.customFieldsNames.equals(projectData.getCustomFieldsNames())) {
                LOG.info("Noticied different setup of custom fields. Forcing to recreate project.");
                projectData = this.createNewEmptyProject(projectId);
            }
            projectData = this.tryUpdateFromLocalJiraFiles(projectData);
            if (!Config.cacheOnly && this.requiresUpdate(projectData)) {
                projectData = this.updateCachedProject(projectData);
            }
            return Optional.of(new AgileProjectFactory().createAgileProject(projectData, configuration.getIssueStatusMapping()));
        }
        catch (IOException ex) {
            LOG.warn("Problem while reading project data of project {}" + projectId, (Throwable)ex);
            return Optional.empty();
        }
    }

    private AgileProjectData createNewEmptyProject(String projectId) {
        return new AgileProjectData(projectId, INITIAL_DATE, INITIAL_DATE, new HashMap<String, IssueData>(), this.customFieldsNames);
    }

    private boolean requiresUpdate(AgileProjectData project) {
        return project.getLastUpdated().isBefore(ZonedDateTime.now().minusMinutes(15L));
    }

    private Optional<AgileProjectData> loadProjectFromFile(String projectId) throws IOException {
        File projectFile = this.getProjectFile(projectId);
        if (projectFile.exists()) {
            return Optional.of(Config.OBJECT_MAPPER.readValue(projectFile, AgileProjectData.class));
        }
        return Optional.empty();
    }

    private File getProjectFile(String projectId) {
        return new File(this.jiraCacheDirectory, projectId + ".json");
    }

    private File getIssueFile(String issueId) {
        return new File(this.jiraCacheIssuesDirectory, issueId + ".json");
    }

    private File[] getIssuesFiles(String projectId) {
        return this.jiraCacheIssuesDirectory.listFiles((dir1, name) -> name.startsWith(projectId + "-"));
    }

    private void saveProjectToFile(AgileProjectData project) throws IOException {
        File projectFile = this.getProjectFile(project.getProjectId());
        Config.OBJECT_MAPPER.writeValue(projectFile, (Object)project);
    }

    private AgileProjectData updateCachedProject(AgileProjectData projectData) throws IOException {
        ZoneId userJiraZoneId = ZoneId.systemDefault();
        String lastUpdatedQueryValue = projectData.getLastUpdatedIssue().withZoneSameInstant(userJiraZoneId).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
        int maxResults = 50;
        int startAt = 0;
        int total = 0;
        do {
            JiraSearchRequest searchRequest = JiraSearchRequest.builder().expand((Set<String>)ImmutableSet.of((Object)"changelog")).jql("project = " + projectData.getProjectId() + " AND updated >= \"" + lastUpdatedQueryValue + "\" ORDER BY updated ASC").maxResults(maxResults).startAt(startAt).build();
            String response = this.httpClient.postJson(this.jiraSearchEndpoint, searchRequest);
            JsonNode tree = Config.OBJECT_MAPPER.readTree(response);
            maxResults = tree.get("maxResults").asInt();
            startAt = tree.get("startAt").asInt();
            total = tree.get("total").asInt();
            ZonedDateTime lastUpdatedIssue = projectData.getLastUpdatedIssue();
            ZonedDateTime lastUpdated = projectData.getLastUpdated();
            HashMap<String, IssueData> issues = new HashMap<String, IssueData>(projectData.getIssues());
            Iterator issuesIterator = tree.get("issues").elements();
            while (issuesIterator.hasNext()) {
                JsonNode node = (JsonNode)issuesIterator.next();
                IssueData issueData = this.issueParser.parseJiraIssue(node);
                if (issueData.getUpdated().isAfter(lastUpdatedIssue)) {
                    lastUpdatedIssue = issueData.getUpdated();
                }
                issues.put(issueData.getKey(), issueData);
                lastUpdated = ZonedDateTime.now();
                try {
                    Config.OBJECT_MAPPER.writeValue(this.getIssueFile(issueData.getKey()), (Object)node);
                }
                catch (IOException ex) {
                    LOG.warn("Unable to store vanila jira issue data. Issue id: {}", (Object)issueData.getKey(), (Object)ex);
                }
            }
            projectData = new AgileProjectData(projectData.getProjectId(), lastUpdatedIssue, lastUpdated, issues, this.customFieldsNames);
            this.saveProjectToFile(projectData);
        } while ((startAt += maxResults) < total);
        return projectData;
    }

    private AgileProjectData tryUpdateFromLocalJiraFiles(AgileProjectData projectData) throws IOException {
        File[] files;
        if (projectData.getIssues().isEmpty() && (files = this.getIssuesFiles(projectData.getProjectId())).length > 0) {
            LOG.info("Project was empty but there were files from jira found in cache. Will try to create project from them before attempting to connect to jira. If this behavior was not expected and you need to read all files freshly from jira, you have to remove all cached files, not only project file.");
            ZonedDateTime lastUpdatedIssue = projectData.getLastUpdatedIssue();
            HashMap<String, IssueData> issues = new HashMap<String, IssueData>(projectData.getIssues());
            for (File file : files) {
                IssueData issueData = this.issueParser.parseJiraIssue(Config.OBJECT_MAPPER.readTree(file));
                if (issueData.getUpdated().isAfter(lastUpdatedIssue)) {
                    lastUpdatedIssue = issueData.getUpdated();
                }
                issues.put(issueData.getKey(), issueData);
            }
            projectData = new AgileProjectData(projectData.getProjectId(), lastUpdatedIssue, lastUpdatedIssue, issues, this.customFieldsNames);
            this.saveProjectToFile(projectData);
        }
        return projectData;
    }
}

