/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.agile.jira;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.kaszaq.howfastyouaregoing.agile.AgileProjectProvider;
import pl.kaszaq.howfastyouaregoing.agile.jira.JiraAgileProjectProvider;
import pl.kaszaq.howfastyouaregoing.http.HttpClient;
import pl.kaszaq.howfastyouaregoing.json.JsonNodeOptional;

public class JiraAgileProjectProviderBuilderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JiraAgileProjectProviderBuilderFactory.class);

    public static JiraAgileProjectProviderBuilder withJsession(String jsessionId) {
        return new JiraAgileProjectProviderBuilder(jsessionId);
    }

    public static JiraAgileProjectProviderBuilder withCredentials(String username, String password) {
        return new JiraAgileProjectProviderBuilder(username, password);
    }

    public static class JiraAgileProjectProviderBuilder {
        private String jsessionId;
        private String username;
        private String password;
        private File cacheDir;
        private String jiraUrl;
        private Map<String, Function<JsonNodeOptional, Object>> customFieldsParsers = Collections.emptyMap();

        private JiraAgileProjectProviderBuilder(String username, String password) {
            this.username = username;
            this.password = password;
        }

        private JiraAgileProjectProviderBuilder(String jsessionId) {
            this.jsessionId = jsessionId;
        }

        public static JiraAgileProjectProviderBuilder withJsessionId(String jsessionId) {
            return new JiraAgileProjectProviderBuilder(jsessionId);
        }

        public static JiraAgileProjectProviderBuilder withCredentials(String username, String password) {
            return new JiraAgileProjectProviderBuilder(username, password);
        }

        public JiraAgileProjectProviderBuilder withCacheDir(File cacheDir) {
            this.cacheDir = cacheDir;
            return this;
        }

        public JiraAgileProjectProviderBuilder withCustomFieldsParsers(Map<String, Function<JsonNodeOptional, Object>> customFieldsParsers) {
            this.customFieldsParsers = customFieldsParsers;
            return this;
        }

        public JiraAgileProjectProviderBuilder withJiraUrl(String jiraUrl) {
            this.jiraUrl = jiraUrl;
            return this;
        }

        public AgileProjectProvider build() {
            HttpClient client = this.jsessionId != null ? new HttpClient(this.jsessionId) : new HttpClient(this.username, this.password);
            if (this.cacheDir == null) {
                this.cacheDir = new File("cache/");
            }
            File jiraCacheDirectory = new File(this.cacheDir, "jira/");
            File jiraCacheIssuesDirectory = new File(jiraCacheDirectory, "issues/");
            jiraCacheDirectory.mkdirs();
            jiraCacheIssuesDirectory.mkdirs();
            String jiraSearchUrl = this.jiraUrl + "/rest/api/2/search";
            return new JiraAgileProjectProvider(client, jiraCacheDirectory, jiraCacheIssuesDirectory, jiraSearchUrl, this.customFieldsParsers);
        }
    }
}

