/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.cycletime;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import pl.kaszaq.howfastyouaregoing.agile.AgileProject;
import pl.kaszaq.howfastyouaregoing.agile.Issue;
import pl.kaszaq.howfastyouaregoing.agile.IssuePredicates;
import pl.kaszaq.howfastyouaregoing.agile.IssueStatusTransition;
import pl.kaszaq.howfastyouaregoing.agile.IssueStatusTransitionPredicates;

public class CycleTimeComputer {
    private final AgileProject agileProject;
    private final Set<String> finalStatuses;

    public double calulcateCycleTimeOfAllIssues(Predicate<Issue> filters, LocalDate fromDate, LocalDate toDate, String ... statuses) {
        LongSummaryStatistics cycleTimeStatistics = this.agileProject.getAllIssues().stream().filter(filters.and(this.wasClosed(fromDate, toDate))).mapToLong(i -> i.getDurationInStatuses(statuses).getSeconds()).summaryStatistics();
        return cycleTimeStatistics.getAverage() / 3600.0;
    }

    public double calulcateCycleTimeOfStories(Predicate<Issue> filters, LocalDate fromDate, LocalDate toDate, String ... statuses) {
        ArrayList durations = new ArrayList();
        this.agileProject.getAllIssues().stream().filter(filters.and(IssuePredicates.hasSubtasks().and(this.wasClosed(fromDate, toDate)))).forEach(issue -> {
            Set<Issue> subtasks = this.getSubtasks((Issue)issue);
            if (this.allSubtasksInFinalStatus(subtasks)) {
                List transitions = subtasks.stream().flatMap(i -> i.getIssueStatusTransitions().stream()).filter(IssueStatusTransitionPredicates.to(statuses).or(IssueStatusTransitionPredicates.from(statuses))).sorted().collect(Collectors.toList());
                Duration duration = !transitions.isEmpty() ? Duration.between(((IssueStatusTransition)transitions.get(0)).getDate(), ((IssueStatusTransition)transitions.get(transitions.size() - 1)).getDate()) : Duration.ZERO;
                durations.add(duration);
            }
        });
        LongSummaryStatistics cycleTimeStatistics = durations.stream().mapToLong(d -> d.getSeconds()).summaryStatistics();
        return cycleTimeStatistics.getAverage() / 3600.0;
    }

    private Predicate<Issue> wasClosed(LocalDate fromDate, LocalDate toDate) {
        return IssuePredicates.hasStatusTransitionsThat(IssueStatusTransitionPredicates.createdAfter(fromDate), IssueStatusTransitionPredicates.createdBefore(toDate), IssueStatusTransitionPredicates.to(this.finalStatuses));
    }

    private boolean allSubtasksInFinalStatus(Set<Issue> subtasks) {
        return !subtasks.stream().anyMatch(s -> !this.finalStatuses.contains(s.getStatus()));
    }

    private Set<Issue> getSubtasks(Issue i) {
        return i.getSubtaskKeys().stream().map(id -> this.agileProject.getIssue((String)id)).collect(Collectors.toSet());
    }

    @ConstructorProperties(value={"agileProject", "finalStatuses"})
    public CycleTimeComputer(AgileProject agileProject, Set<String> finalStatuses) {
        this.agileProject = agileProject;
        this.finalStatuses = finalStatuses;
    }
}

