/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Base64;
import java.util.Collection;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.kaszaq.howfastyouaregoing.Config;

public class HttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClient.class);
    private final CloseableHttpClient httpClient;

    public HttpClient(String jsessionId) {
        this.httpClient = HttpClients.custom().setDefaultHeaders((Collection)Lists.newArrayList((Object[])new BasicHeader[]{new BasicHeader("Cookie", "JSESSIONID=" + jsessionId)})).build();
    }

    public HttpClient(String username, String password) {
        String encodedCredentials = Base64.getEncoder().encodeToString((username + ":" + password).getBytes());
        this.httpClient = HttpClients.custom().setDefaultHeaders((Collection)Lists.newArrayList((Object[])new BasicHeader[]{new BasicHeader("Authorization", "Basic " + encodedCredentials)})).build();
    }

    public String get(String url) throws IOException {
        HttpGet httpGet = new HttpGet(url);
        LOG.info("Executing GET request {}", (Object)httpGet.getRequestLine());
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);){
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            return string;
        }
    }

    public String postJson(String url, Object object) throws IOException, JsonProcessingException, UnsupportedCharsetException, ParseException {
        String response;
        HttpPost post = new HttpPost(url);
        String entity = Config.OBJECT_MAPPER.writeValueAsString(object);
        LOG.info("Executing POST request {} with body {}", (Object)post.getRequestLine(), (Object)entity);
        StringEntity requestEntity = new StringEntity(entity, ContentType.APPLICATION_JSON);
        post.setEntity((HttpEntity)requestEntity);
        try (CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)post);){
            response = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        }
        return response;
    }
}

