/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.utils;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;

public class DateUtils {
    private static final DateTimeFormatter EXCEL_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
    private static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final DateTimeFormatter SIMPLE_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter MONTH_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM");

    public static ZonedDateTime parseDate(String date) {
        ZonedDateTime createdDate = ZonedDateTime.parse(date, DATETIME_FORMATTER);
        return createdDate;
    }

    public static String printDateTimeExcel(ZonedDateTime date) {
        return date.format(EXCEL_DATETIME_FORMATTER);
    }

    public static String printDate(ZonedDateTime date) {
        return date.format(DATETIME_FORMATTER);
    }

    public static String printSimpleDate(ZonedDateTime date) {
        return date.format(SIMPLE_DATE_FORMATTER);
    }

    public static String printSimpleDate(LocalDate date) {
        return date.format(SIMPLE_DATE_FORMATTER);
    }

    public static String printMonthOnlyDate(ZonedDateTime date) {
        return date.format(MONTH_DATE_FORMATTER);
    }

    public static Collection<? extends LocalDate> getCollectionOfLocalDates(ZonedDateTime from, ZonedDateTime to) {
        return DateUtils.getCollectionOfLocalDates(from, to, Integer.MAX_VALUE);
    }

    public static Collection<? extends LocalDate> getCollectionOfLocalDates(ZonedDateTime from, ZonedDateTime to, int max) {
        if (from == null) {
            System.out.println("Co jest grane?");
        }
        LocalDate fromLocalDate = LocalDate.from(from.withZoneSameInstant(ZoneId.systemDefault()));
        LocalDate toLocalDate = LocalDate.from(to.withZoneSameInstant(ZoneId.systemDefault()));
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        for (int count = 0; !fromLocalDate.isAfter(toLocalDate) && count < max; ++count) {
            dates.add(fromLocalDate);
            fromLocalDate = fromLocalDate.plusDays(1L);
        }
        return dates;
    }

    public static Collection<? extends LocalDate> getCollectionOfLocalDatesBetweenDateExclusive(ZonedDateTime from, ZonedDateTime to) {
        LocalDate fromLocalDate = LocalDate.from(from.withZoneSameInstant(ZoneId.systemDefault())).plusDays(1L);
        LocalDate toLocalDate = LocalDate.from(to.withZoneSameInstant(ZoneId.systemDefault())).minusDays(1L);
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        while (!fromLocalDate.isAfter(toLocalDate)) {
            dates.add(fromLocalDate);
            fromLocalDate = fromLocalDate.plusDays(1L);
        }
        return dates;
    }
}

