/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.agile;

import java.util.HashMap;
import java.util.Map;
import pl.kaszaq.howfastyouaregoing.agile.AgileClient;
import pl.kaszaq.howfastyouaregoing.agile.AgileProjectConfiguration;
import pl.kaszaq.howfastyouaregoing.agile.AgileProjectProvider;

public final class AgileClientFactory {
    public static AgileClientConstructor newClient() {
        return new AgileClientConstructor();
    }

    private AgileClientFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class AgileClientConstructor {
        Map<String, AgileProjectConfiguration> configuration = new HashMap<String, AgileProjectConfiguration>();
        AgileProjectProvider agileProjectProvider;

        private AgileClientConstructor() {
        }

        public AgileClientConstructor withAgileProjectConfig(String projectId, AgileProjectConfiguration projectConfiguration) {
            this.configuration.put(projectId, projectConfiguration);
            return this;
        }

        public AgileClientConstructor withAgileProjectProvider(AgileProjectProvider agileProjectProvider) {
            this.agileProjectProvider = agileProjectProvider;
            return this;
        }

        public AgileClient create() {
            return new AgileClient(this.configuration, this.agileProjectProvider);
        }
    }
}

