/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.agile;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import pl.kaszaq.howfastyouaregoing.agile.AgileProject;
import pl.kaszaq.howfastyouaregoing.agile.Issue;
import pl.kaszaq.howfastyouaregoing.agile.IssueData;
import pl.kaszaq.howfastyouaregoing.agile.IssueStatusMapping;
import pl.kaszaq.howfastyouaregoing.agile.IssueStatusTransition;
import pl.kaszaq.howfastyouaregoing.agile.pojo.AgileProjectData;

public class AgileProjectFactory {
    public AgileProject createAgileProject(AgileProjectData projectData, IssueStatusMapping statusMapping) {
        HashMap<String, Issue> transformedAgileProjectData = new HashMap<String, Issue>();
        Set<String> newAllStatuses = this.calculateNewValidStatuses(statusMapping, projectData);
        projectData.getIssues().entrySet().forEach(entry -> {
            String k = (String)entry.getKey();
            IssueData v = (IssueData)entry.getValue();
            Issue issue = new Issue(IssueData.builder().created(v.getCreated()).creator(v.getCreator()).summary(v.getSummary()).description(v.getDescription()).issueStatusTransitions(this.remapStatusTransitions(v, statusMapping, newAllStatuses)).issueBlockedTransitions(v.getIssueBlockedTransitions()).key(v.getKey()).linkedIssuesKeys(v.getLinkedIssuesKeys()).parentIssueKey(v.getParentIssueKey()).resolution(v.getResolution()).subtask(v.isSubtask()).subtaskKeys(v.getSubtaskKeys()).status(v.getStatus()).updated(v.getUpdated()).type(v.getType()).labels(v.getLabels()).components(v.getComponents()).customFields(v.getCustomFields()).build());
            transformedAgileProjectData.put(k, issue);
        });
        return new AgileProject(projectData.getProjectId(), transformedAgileProjectData);
    }

    private Set<String> calculateNewValidStatuses(IssueStatusMapping statusMapping, AgileProjectData projectData) {
        Set<String> newAllStatuses = new HashSet<String>();
        if (projectData.getStatuses() == null) {
            newAllStatuses = projectData.getIssues().values().stream().flatMap(i -> i.getIssueStatusTransitions().stream()).map(t -> t.getToStatus()).distinct().collect(Collectors.toSet());
        } else {
            newAllStatuses.addAll(projectData.getStatuses().getDoneStatuses());
            newAllStatuses.addAll(projectData.getStatuses().getIndeterminateStatuses());
            newAllStatuses.addAll(projectData.getStatuses().getNewStatuses());
            newAllStatuses.addAll(projectData.getStatuses().getUndefinedStatuses());
        }
        if (statusMapping != null) {
            newAllStatuses = newAllStatuses.stream().map(s -> statusMapping.getMappings().getOrDefault(s, (String)s)).collect(Collectors.toSet());
        }
        return newAllStatuses;
    }

    private TreeSet<IssueStatusTransition> remapStatusTransitions(IssueData v, IssueStatusMapping statusMapping, Set<String> newAllStatuses) {
        if (statusMapping == null) {
            return v.getIssueStatusTransitions();
        }
        TreeSet<IssueStatusTransition> newStatusTransitionSet = new TreeSet<IssueStatusTransition>();
        String previousStatus = null;
        boolean added = true;
        String newFromStatus = null;
        for (IssueStatusTransition issueStatusTransition : v.getIssueStatusTransitions()) {
            String newToStatus;
            if (added) {
                newFromStatus = statusMapping.mapStatus(issueStatusTransition.getFromStatus());
                newFromStatus = this.fixStatusFlowContinuityIfBroken(previousStatus, newFromStatus);
                added = false;
            }
            if (!newAllStatuses.contains(newToStatus = statusMapping.mapStatus(issueStatusTransition.getToStatus()))) continue;
            added = true;
            previousStatus = newToStatus;
            IssueStatusTransition newStatusTransition = new IssueStatusTransition(issueStatusTransition.getUser(), issueStatusTransition.getDate(), newFromStatus, newToStatus);
            newStatusTransitionSet.add(newStatusTransition);
        }
        return newStatusTransitionSet;
    }

    private String fixStatusFlowContinuityIfBroken(String previousStatus, String newFromStatus) {
        if (previousStatus == null && newFromStatus != null || previousStatus != null && !previousStatus.equals(newFromStatus)) {
            newFromStatus = previousStatus;
        }
        return newFromStatus;
    }
}

